package kvk.Utils;
import robocode.*;

/**
 *  Description of the Class
 *
 * @author     Ssin.le.Terrible
 * @created    9 janvier 2004
 */
public final class Fct {

	/**
	 *  Renvoie un angle compris entre 0 et 2*PI
	 *
	 * @param  angle  Description of the Parameter
	 * @return        Description of the Return Value
	 */
	public static double absAngle(double angle) {
		return (angle < 0 ? angle % C._2PI + C._2PI : angle % C._2PI);
	}

	/**
	 *  Renvoie l'angle form par 1 vecteur (relX,relY)
	 *
	 * @param  relX  Description of the Parameter
	 * @param  relY  Description of the Parameter
	 * @return       Description of the Return Value
	 */
	public static double arcTan(double relX, double relY) {

		if (relX == 0.0) {
			return (relY > 0.0 ? 0d : C._PI);
		}
		else {
			return (relX > 0.0 ? C._PI2 : C._3PI2) - Math.atan(relY / relX);
		}
	}

	/**
	 *  Renvoie l'angle entre 2 points de -PI  +PI
	 *
	 * @param  deX  Description of the Parameter
	 * @param  deY  Description of the Parameter
	 * @param  aX   Description of the Parameter
	 * @param  aY   Description of the Parameter
	 * @return      Description of the Return Value
	 */
	public static double bearing(double deX, double deY, double aX, double aY) {
		//return relAngle(arcTan(aX - deX, aY - deY));
		return Math.atan2(aX - deX, aY - deY);
	}

	public static double bearing(Point p1, Point p2) {
		return bearing(p1.getX(), p1.getY(), p2.getX(), p2.getY());
	}

	/**
	 *  Calcule les dommages causs par un boulet
	 *
	 * @param  bulletPower  Description of the Parameter
	 * @return              Description of the Return Value
	 */
	public static double bulletDamage(double bulletPower) {

		double  damage  = bulletPower * C.HIT_DAMAGE;
		if (bulletPower > 1) {
			damage += (bulletPower - 1) * C.ADDITIONAL_HIT_DAMAGE;
		}
		return damage;
	}

	/**
	 *  Calcule la vitesse d'un boulet
	 *
	 * @param  firePower  Description of the Parameter
	 * @return            Description of the Return Value
	 */
	public static double bulletSpeed(double firePower) {
		return C.MAX_BULLET_SPEED - (3 * firePower);
	}

	/**
	 *  Cacule les dommages de collision contre un mur
	 *
	 * @param  speed  Description of the Parameter
	 * @return        Description of the Return Value
	 */
	public static double calcWallDamage(double speed) {
		return Math.max(Math.abs(speed) * .5 - 1, 0);
	}

	/**
	 *  Renvoie la nouvelle abscisse
	 *
	 * @param  x         Description of the Parameter
	 * @param  heading   Description of the Parameter
	 * @param  distance  Description of the Parameter
	 * @return           Description of the Return Value
	 */
	public static double calcX(double x, double heading, double distance) {
		return x + Math.sin(heading) * distance;
	}

	/**
	 *  Renvoie les nouvelles coordonnes
	 *
	 * @param  p         Description of the Parameter
	 * @param  heading   Description of the Parameter
	 * @param  distance  Description of the Parameter
	 * @return           Description of the Return Value
	 */
	public static Point calcXY(Point p, double heading, double distance) {
		return new Point(calcX(p.getX(), heading, distance), calcY(p.getY(), heading, distance));
	}

	/**
	 *  Renvoie la nouvelle ordonne
	 *
	 * @param  y         Description of the Parameter
	 * @param  heading   Description of the Parameter
	 * @param  distance  Description of the Parameter
	 * @return           Description of the Return Value
	 */
	public static double calcY(double y, double heading, double distance) {
		return y + Math.cos(heading) * distance;
	}

	// **************************************************************************** //
	//                       CODAGE et DECODAGE de MOUVEMENTS                       //
	// **************************************************************************** //
	/**
	 *  Transforme des coordonnes en charactre
	 *
	 * @param  x  Description of the Parameter
	 * @param  y  Description of the Parameter
	 * @return    Description of the Return Value
	 */
	public static String codeDeltaCoordToString(double x, double y) {
		//Passage de (-8;+8)  (0;+255)
		int     intX  = Math.max((int)(x * 16 + 127), 0);
		int     intY  = Math.max((int)(y * 16 + 127), 0);

		String  s     = "" + (char)intX + (char)intY;
		return s;
	}

	public static String codeDeltaCoordToString(Point deltaCoord) {
		return codeDeltaCoordToString(deltaCoord.getX(), deltaCoord.getY());
	}

	/**
	 *  Transforme un charactre en coordonnes
	 *
	 * @param  s  Description of the Parameter
	 * @return    Description of the Return Value
	 */
	public static Point decodeStringToDeltaCoord(String s) {
		if (s.length() < 2) {
			return new Point();
		}

		char  cX  = s.charAt(0);
		char  cY  = s.charAt(1);
		return new Point(((double)cX - 127d) / 16d, ((double)cY - 127d) / 16d);
	}
	// **************************************************************************** //

	/**
	 *  Transforme des coordonnes en charactre OLD VERSION
	 *
	 * @param  x  Description of the Parameter
	 * @param  y  Description of the Parameter
	 * @return    Description of the Return Value
	 */
	public static char codeDeltaCoordToStringOld(double x, double y) {
		//Passage de (-8;+8)  (0;+64)
		int  intX  = (int)(x * 4 + 32);
		int  intY  = (int)(y * 4 + 32);

		return (char)((intX) | (intY << 8));
	}

	/**
	 *  Transforme un charactre en coordonnes
	 *
	 * @param  c  Description of the Parameter
	 * @return    Description of the Return Value
	 */
	public static Point decodeStringToDeltaCoordOld(char c) {
		return new Point((c & 255) / 4d - 8d, (c >> 8) / 4d - 8d);
	}

	/**
	 *  Renvoie l'angle entre 2 points de 0  2*PI
	 *
	 * @param  deX  Description of the Parameter
	 * @param  deY  Description of the Parameter
	 * @param  aX   Description of the Parameter
	 * @param  aY   Description of the Parameter
	 * @return      Description of the Return Value
	 */
	public static double heading(double deX, double deY, double aX, double aY) {
		//return arcTan(aX - deX, aY - deY);
		return absAngle(bearing(deX, deY, aX, aY));
	}

	public static double heading(Point p1, Point p2) {
		return heading(p1.getX(), p1.getY(), p2.getX(), p2.getY());
	}

	public static double heading(Point p) {
		return heading(0d, 0d, p.getX(), p.getY());
	}

	/**
	 *  Renvoie le nombre compris entre les 2 limites
	 *
	 * @param  valeur  Description of the Parameter
	 * @param  mini    Description of the Parameter
	 * @param  maxi    Description of the Parameter
	 * @return         Description of the Return Value
	 */
	public static double limite(double valeur, double mini, double maxi) {

		return Math.max(Math.min(valeur, maxi), mini);
	}

	public static long limite(long valeur, long mini, long maxi) {

		return Math.max(Math.min(valeur, maxi), mini);
	}

	public static int limite(int valeur, int mini, int maxi) {

		return Math.max(Math.min(valeur, maxi), mini);
	}

	/**
	 *  Angle maxi parcourue par un bot avant d'tre touch
	 *
	 * @param  speed  Description of the Parameter
	 * @return        Description of the Return Value
	 */
	public static double maxEscapeAngle(double speed) {
		return Math.asin(8d / speed);
	}

	/**
	 *  Distance maxi parcourue par un bot avant d'tre touch
	 *
	 * @param  speed  Description of the Parameter
	 * @return        Description of the Return Value
	 */
	public static double maxEscapeDistance(double speed) {
		//return 8d / speed / Math.cos(maxEscapeAngle(speed));
		return Math.tan(maxEscapeAngle(speed));
	}

	public static double maxEscapeDistance(double speed, double distance) {
		return maxEscapeDistance(speed) * distance;
	}

	/**
	 *  Ajoute des 0 devant
	 *
	 * @param  str   Description of the Parameter
	 * @param  size  Description of the Parameter
	 * @return       Description of the Return Value
	 */
	public static String padZeros(String str, int size) {
		while (str.length() < size) {
			str = "0" + str;
		}
		return str;
	}

	/**
	 *  Renvoie un nombre alatoire compris entre 0 et limite
	 *
	 * @param  limite  Description of the Parameter
	 * @return         Description of the Return Value
	 */
	public static double random(double limite) {
		return Math.random() * limite;
	}

	public static int random(int limite) {
		return (int)(Math.random() * limite);
	}

	/**
	 *  Renvoie un angle compris entre -PI et +PI
	 *
	 * @param  angle  Description of the Parameter
	 * @return        Description of the Return Value
	 */
	public static double relAngle(double angle) {
		double  a  = angle % C._2PI;
		if (a < -C._PI) {
			return a + C._2PI;
		}
		else if (a > C._PI) {
			return a - C._2PI;
		}
		else {
			return a;
		}
	}

	/**
	 *  Renvoie l'angle le plus court pour tourner de angle1  angle2
	 *
	 * @param  angle1  Description of the Parameter
	 * @param  angle2  Description of the Parameter
	 * @return         Description of the Return Value
	 */
	public static double relAngle(double angle1, double angle2) {
		return relAngle(angle2 - angle1);
	}

	/**
	 * Paul Evans' excellent function for keeping rolling averages
	 *
	 * @param  value      valeur moyenne
	 * @param  newEntry   nouvelle entre
	 * @param  n          nb de donnes
	 * @param  weighting  poids
	 * @return            Description of the Return Value
	 */
	public static double rollingAvg(double value, double newEntry, double n, double weighting) {
		return (value * n + newEntry * weighting) / (n + weighting);
	}

	/**
	 *  Renvoie l'arrondi  2 dcimales de a
	 *
	 * @param  a  Description of the Parameter
	 * @return    Description of the Return Value
	 */
	public static double round2(double a) {
		return (double)Math.round(a * 100) / 100;
	}

	/**
	 *  Renvoie l'arrondi  4 dcimales de a
	 *
	 * @param  a  Description of the Parameter
	 * @return    Description of the Return Value
	 */
	public static double round4(double a) {
		return (double)Math.round(a * 10000) / 10000;
	}

	/**
	 *  Renvoie le signe d'une valeur double
	 *
	 * @param  valeur  Description of the Parameter
	 * @return         Description of the Return Value
	 */
	public static double signe(double valeur) {
		return (valeur < 0 ? -1.0 : 1.0);
	}

	public static int signe(int valeur) {
		return (valeur < 0 ? -1 : 1);
	}

	/**
	 *  Renvoie une chaine contenant le temps
	 *
	 * @param  ar  Description of the Parameter
	 * @return     Description of the Return Value
	 */
	public static String strTime(AdvancedRobot ar) {
		return "[" + ar.getTime() + "] ";
	}

	/**
	 *  Calcule la vitesse de rotation
	 *
	 * @param  speed  Description of the Parameter
	 * @return        Description of the Return Value
	 */
	public static double turnRate(double speed) {
		return Math.toRadians(C.TURN_CONSTANT_1 - C.TURN_CONSTANT_2 * speed);
	}
}

