package djc;
import robocode.*;

/**
 * IncomingBullet
 *  Heading is in radians
 */
public class IncomingBullet extends MovingObject
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */
    public static final String DIRECT = "DIRECT_";
    public static final String PREDICTIVE = "PREDICTIVE_";

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    public double energy = 0;
    public String modellingMethod = "";

    /**
     * IncomingBullet Constructor
     *
     * @param targetName - String for the name
     */
    public IncomingBullet(String targetName)
    {
	name = targetName;
	strength = GravPoint.DEFAULT_INCOMING_BULLET_STRENGTH;
	exponent = GravPoint.INCOMING_BULLET_EXPONENT;
    }

    /**
     * Sets the updates the current position
     *
     * @param curTime - current time.
     */
    public void updatePosition(double curTime)
    {
	double dT = curTime - lastTimePosition;
	x = x + dT * velocity * Math.sin(heading_rad);
	y = y + dT * velocity * Math.cos(heading_rad);
	lastTimePosition = curTime;
    }
}
