package djc;
import robocode.*;

/**
 * PatternTargetingStrategy.  Based on JollyNinja
 */
public class PatternTargetingStrategy extends TargetingStrategy
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */
    /** How big to estimate the target as */
    public static final double TARGET_RADIUS = 20.0;

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    public PatternAnalyser pa = null;
    public boolean isPredictionReliable = false;

    PatternTargetingStrategy(Target pt, PatternAnalyser patternAnalyser)
    {
        super(pt);
	pa = patternAnalyser;
        name = TargetingStrategyManager.PATTERN;
    }

    /**
     * predictCoordinates
     * <br>
     *
     *  @return Coordinate
     */
    public Coordinate predictCoordinate(double curTime, double futureTime)
    {
	Coordinate relativeNormalisedPosition = pa.getEstimatedDeltaPosition(t.velocity, futureTime);
	Coordinate relativeAbsolutePosition = relativeNormalisedPosition.rotate(t.heading_rad);
	double error = pa.futurePositionArray.getError(t.velocity, futureTime);
	isPredictionReliable = (error < (2 * TARGET_RADIUS));
	return t.position.plus(relativeAbsolutePosition);
    }

}
