package zyx.mega.radar;

import static zyx.mega.utils.Config.*;
import static zyx.mega.utils.TurnHandler.*;
import static zyx.mega.utils.Range.*;
import static zyx.mega.geometry.Geometry.*;
import static java.lang.Math.*;
import static java.lang.Double.*;
import static robocode.util.Utils.*;
import static zyx.mega.bot.Enemy.*;
import static zyx.mega.bot.Bot.*;

import java.lang.Double;

import java.util.LinkedHashMap;

import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import zyx.mega.bot.Enemy;

public class Radar {
  public LinkedHashMap<Enemy, Double> hash_map_;
  public double scan_angle_;
  public Enemy sought_;
  public Radar() {
    if ( _melee_ ) hash_map_ = new LinkedHashMap<Enemy, Double>(5, 2, true);
  }
  public void Init() {
    if ( _melee_ ) hash_map_.clear();
    scan_angle_ = POSITIVE_INFINITY;
  }
  public void run() {
    robot_.setTurnRadarRightRadians(scan_angle_);
  }
  public void onScannedRobot(Enemy enemy) {
    //System.out.println(enemy + " : " + enemy.name_);
    LinkedHashMap<String, Integer> a = new LinkedHashMap<String, Integer>(5, 2, true);
    
    if ( _1v1_ ) scan_angle_ = normalRelativeAngle(enemy.bearing_ - robot_.getRadarHeadingRadians()) * 1.999;
    else {
      hash_map_.put(enemy, enemy.bearing_);
      //System.out.printf("radar(%s): %d(%s): %d %d\n", sought_, time_, enemy, hash_map_.size(), others_);
      if ( (enemy == sought_ || sought_ == null) && hash_map_.size() == others_ ) {
        scan_angle_ = normalRelativeAngle(hash_map_.values().iterator().next() - robot_.getRadarHeadingRadians());
        sought_ = hash_map_.keySet().iterator().next();
        //System.out.println(scan_dir_);
      }
    }
  }
  public void onRobotDeath(Enemy enemy) {
    hash_map_.remove(enemy);
    sought_ = null;
  }
}
