package kc.micro;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.awt.Color;

/**
* Needle, by Kevin Clark (Kev).
* Multimode movement and a pattern matching gun with multiple choice. 
* See http://robowiki.net/cgi-bin/robowiki?Needle for more information. 
*/
public class Needle extends AdvancedRobot {
	static final int AIM_FACTORS = 81;
	static final int MIDDLE_FACTOR = (AIM_FACTORS - 1) / 2;
	static final double MAX_ESCAPE_ANGLE = (0.6082455789 / (MIDDLE_FACTOR / 2));
	
	static Point2D.Double enemyLocation;
	static double enemyEnergy;
	static double lastEnemyBulletSpeed;
	static double moveFactor = 48;
	static int movementMode;

	public void run() {
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		do {
			turnRadarLeftRadians(1);
		} while(true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		if((enemyEnergy -= e.getEnergy()) > 0 && enemyEnergy <= 3.0) {
			setAhead(moveFactor);
			lastEnemyBulletSpeed = 20 - (3 * enemyEnergy);
		}
		
		double enemyDistance = e.getDistance();		
		double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		Point2D.Double myLocation = new Point2D.Double(getX(), getY());
		enemyLocation = projectMotion(myLocation, absoluteBearing, enemyDistance);
		
		if(movementMode > 0) {
			if(Math.random() < 0.65 * Math.pow(enemyDistance / lastEnemyBulletSpeed, -0.65)) {	
				moveFactor = -moveFactor;
			}
			setAhead(moveFactor);
		}
		double smoothedHeading = enemyEnergy = absoluteBearing + Math.PI/2 - ((enemyDistance - 500.0) * moveFactor / 30000.0);
		while(!new Rectangle2D.Double(20, 20, 760, 560).contains(projectMotion(myLocation, smoothedHeading -= (moveFactor / 2500.0), (movementMode + 1.5) * moveFactor)));
		
		if(Math.abs(smoothedHeading - enemyEnergy) > Math.PI/3) {
			setAhead(movementMode * (moveFactor = -moveFactor));
		}
		setTurnRightRadians(Utils.normalRelativeAngle(smoothedHeading - getHeadingRadians()));
		
		int bestIndex = MIDDLE_FACTOR;
		int matchLen = 30;
		int matchPos;
		int predictPos;
		int evaluatedPatterns;
			
		enemyHistory = String.valueOf((char)(e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing))).concat(enemyHistory);
		
		smoothedHeading = (20 - (3 * (enemyEnergy = Math.min(Math.min(enemyDistance < 125 ? 3 : 1.9, getEnergy() / 5), e.getEnergy() / 4))));
		
		while(matchLen-- > 1) {
			matchPos = -1;
			evaluatedPatterns = 0;
							
			double[] angleValue = new double[AIM_FACTORS];
		
			while((predictPos = matchPos = enemyHistory.indexOf(
				  enemyHistory.substring(0, matchLen), 
				  Math.max(matchPos + 1, (int)(enemyDistance / (smoothedHeading - 4))))) >= 0) {
				
				evaluatedPatterns++;
				
				double d = -smoothedHeading;
				double offset = 0;
				do {
					offset += (short)enemyHistory.charAt(--predictPos);
				} while (predictPos > 0 && (d += smoothedHeading) * d < (enemyDistance * enemyDistance) + (offset * offset));
			
				double bestValue = 0;
				int bin = AIM_FACTORS - 1;
				do {
					if((angleValue[bin] += 1 / (1 + Math.abs(bin - MIDDLE_FACTOR + (int)(Math.atan(offset / enemyDistance) / MAX_ESCAPE_ANGLE))))
						> bestValue) {
						bestValue = angleValue[bin];
						bestIndex = bin;
					}
				} while(bin-- > 0);
			}
		
			if(evaluatedPatterns > 5 + (int)Math.pow(enemyHistory.length(), 0.35)) {
				break;
			}
		}
				
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing + ((MIDDLE_FACTOR - bestIndex) * MAX_ESCAPE_ANGLE) - getGunHeadingRadians()));
	
		if((int)(getEnergy()) > 1) {
			setFire(enemyEnergy);
		}
	
		setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
		enemyEnergy = e.getEnergy();
		
	}
	
	public void onBulletHit(BulletHitEvent e) {
		enemyEnergy = e.getEnergy();
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		enemyEnergy += 3 * e.getPower();
	}
	
	public void onDeath(DeathEvent e) {
		if(getRoundNum() < 5) {
			movementMode = 2;
		}
	}
	
	static Point2D.Double projectMotion(Point2D.Double location, double heading, double distance) {	
		return new Point2D.Double(location.x + distance * Math.sin(heading), location.y + distance * Math.cos(heading));			
	}

	static String enemyHistory = ""
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50
		+ (char) 50 + (char) 50 + (char) 50 + (char) 50;
}
