/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package robar.nano;
import robocode.*;
import robocode.util.*;
import java.awt.*;
/**
 *
 * @author RB
 */
public class Vespa extends AdvancedRobot{

    static final int PATTERN_DEPTH = 30;
    static final double FP = 2.5;
    static final double BV = 20-3*FP;
    static final double MOVE = 5;

    static double prevEnergy;
    static double dir = MOVE;
    //static double revChance;
    static StringBuffer enemyLog = new StringBuffer("00012345678888888888888888888");


    public void run(){
        setAdjustGunForRobotTurn(true);
        setTurnRadarRight(Double.POSITIVE_INFINITY);

    }

    public void onScannedRobot(ScannedRobotEvent e){
        double absB;
        int index;
        int matchLenght = PATTERN_DEPTH;

        enemyLog.insert(0, (char)((int)(Math.sin(e.getHeadingRadians() - ( absB=e.getBearingRadians()+getHeadingRadians()))*e.getVelocity())));
        while ((index = enemyLog.toString().indexOf(enemyLog.substring(0, matchLenght--), 1)) < 0);
        matchLenght = index - (int)(e.getDistance()/BV);
        do{
            absB += Math.asin(((byte)enemyLog.charAt(index--))/e.getDistance());
        }while(index>=Math.max(0, matchLenght));

        setTurnGunRightRadians(Utils.normalRelativeAngle(absB-getGunHeadingRadians()));
        setFire(FP);


        if( prevEnergy - (prevEnergy = e.getEnergy()) > 0.0 && getDistanceRemaining()==0.0){

            //setAhead(dir*Math.signum(Math.random()-revChance));
            setAhead(dir*Math.random()*37);
            //setAhead(Math.copySign(dir, Math.random()-revChance));

        }


        setTurnRight(e.getBearing()+90-dir);


        setTurnRadarLeft(getRadarTurnRemaining());
    }

    public void onHitWall(HitWallEvent e){
        dir = -dir;
    }
    /*public void onDeath(DeathEvent e){
        revChance += 0.05;
    }*/
}
