package disan;
import robocode.*;
import robocode.util.*;
import java.awt.*;


/**
 * Chair - a robot by Disan
 */
public class Chair extends AdvancedRobot
{
	double preEnergy = 100;
	double changeEnergy = 0;
	double firePower = 1;
	static double fireDirectShot = 1, fireDirectHit = 1;
	static double fireFrontShot = 0, fireFrontHit = 0;
	static double fireShot = 0, fireHit = 0;
	int typeFire = 1;
	double direction = 137;
	double distanceCheck = 0;
	public int d = 1;
	public int radarD = 1;
	
	public void run() {
    setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
    setAdjustGunForRobotTurn(true);
	setColors(Color.BLACK, Color.BLUE, Color.DARK_GRAY);
		while(true) {

			setTurnRadarRight(45*radarD);		
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if(getVelocity() == 0 ){setAhead(direction = - direction );}
		//If statments to get around 300 pixels
		if(e.getDistance()>400){
			setTurnRightRadians(e.getBearingRadians()+(Math.PI/2)-(Math.PI/6)*direction/137);
		}
		else{
			setTurnRightRadians(e.getBearingRadians()+(Math.PI/2)+(Math.PI/12)*direction/137);
		}
	
		//Checks for bullet fired
		changeEnergy = preEnergy - e.getEnergy();
		if(changeEnergy>0 && changeEnergy<=3 )
		{
			direction = -direction;
		}


		
		//to keep radar on enemy
		radarD = -radarD;
		setTurnRadarRight(99999*radarD);
		if(e.getDistance() < 600){
			//Fire
			if (fireShot <= 10 || fireFrontHit/fireFrontShot >= fireDirectHit/fireDirectShot){
				typeFire = 1;
				double absoluteBearing = (getHeadingRadians() + e.getBearingRadians());
				setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + (e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing) / 13.0))); 
	
			}
			else{
				typeFire = 2;
				setTurnGunRightRadians(Utils.normalRelativeAngle(getHeadingRadians() + e.getBearingRadians() - getGunHeadingRadians())) ;
			}
		
			firePower = (3-(3*(e.getDistance()/750)));
			setFire(firePower);
		}
		//new enemy energy
		preEnergy = e.getEnergy();
		scan();
	}

	
		
	//On bullet hitting enemy 
	public void onBulletHit(BulletHitEvent e){
		fireShot = fireShot + 1;
		if (typeFire==1){
			fireFrontHit = fireFrontHit + 1;
			fireFrontShot = fireFrontShot + 1;
		}
		else if (typeFire==2){
			fireDirectHit = fireDirectHit + 1;			
			fireDirectShot = fireDirectShot + 1;
		}
	}
	
	//On bullet Missing enemy
	public void onBulletMissed(BulletMissedEvent e){
		fireShot = fireShot + 1;
		if (typeFire==1){
			fireFrontShot = fireFrontShot + 1;
		}
		else if (typeFire==2){
			fireDirectShot = fireDirectShot + 1;
		}
	}
	//On Hit Wall
	public void onHitWall(HitWallEvent e){
		direction = -direction;
	}		
}
								