package froh.micro;

import robocode.*;
import static robocode.util.Utils.normalRelativeAngle;
import java.awt.Color;

public class Aversari extends AdvancedRobot
{
	private final double MARGIN = 44d;

	private double width, height, rand, bearing, distance, heading, speed, pX, pY, vX, vY;
	private int direction;

	public void run()
	{
		width = getBattleFieldWidth();
		height = getBattleFieldHeight();

		direction = 1;

		setAllColors(Color.GREEN);
		setAdjustGunForRobotTurn(true);
 		setAdjustRadarForGunTurn(true);
 		setAdjustRadarForRobotTurn(true);

		do
		{
			if (getTime()%(30 + (int)rand*20) == 0)
				rand = Math.random();

			if (getRadarTurnRemainingRadians() == 0d)
				setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			gunRoutine();
			move();
			execute();
		}
		while (true);
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		bearing = e.getBearingRadians();
		distance = e.getDistance();
		heading = e.getHeadingRadians();
		speed = (speed + e.getVelocity()) / 2;

		pX = distance * Math.sin(bearing + getHeadingRadians()) + getX();
		pY = distance * Math.cos(bearing + getHeadingRadians()) + getY();

		vX = speed * Math.sin(heading);
		vY = speed * Math.cos(heading);

		setTurnRadarRightRadians(2*normalRelativeAngle(bearing + getHeadingRadians() - getRadarHeadingRadians()));
	}

	private void move()
	{
		double targetPosition, targX, targY, newHeading, hBearing, tBearing;
		targetPosition = Math.atan2(pX - width/2, pY - height/2) + Math.PI + (2*rand - 1)*2;

		targX = ((width/2) - MARGIN) * Math.sin(targetPosition) + width/2;
		targY = ((height/2) - MARGIN) * Math.cos(targetPosition) + height/2;

		newHeading = Math.atan2(targX - getX(), targY - getY());

		hBearing = normalRelativeAngle(newHeading - getHeadingRadians());
		tBearing = normalRelativeAngle((newHeading + Math.PI) - getHeadingRadians());

		if (Math.abs(hBearing) < Math.abs(tBearing))
		{
			setTurnRightRadians(hBearing);
			direction = 1;
		}
		else
		{
			setTurnRightRadians(tBearing);
			direction = -1;
		}

		if (getTurnRemaining() < 60)
			setAhead(direction*Math.sqrt(Math.pow(targX - getX(), 2) + Math.pow(targY - getY(), 2))); // *(rand + 0.2)
	}

	private void gunRoutine()
	{
		double bulletPower, delay, rDelay;

		bulletPower = 400 / distance;
		if (speed > 1)
		{
			delay = distance / (20 - 3 * bulletPower);
			rDelay = (Math.sqrt(Math.pow(pX + vX * delay - getX(), 2) + Math.pow(pY + vY * delay - getY(), 2)) / (20 - 3 * bulletPower) + delay) / 2;

			setTurnGunRightRadians(normalRelativeAngle(Math.atan2((pX + vX * rDelay - getX()), pY + vY * rDelay - getY()) - getGunHeadingRadians()));
		}
		else
		{
			setTurnGunRightRadians(normalRelativeAngle(bearing + getHeadingRadians() - getGunHeadingRadians()));
		}

		if (getGunHeat() == 0 && Math.abs(getGunTurnRemaining()) < 5)
		{
			fire(bulletPower);
		}
	}

	// public void onHitByBullet(HitByBulletEvent e)
	// {
	// 	rand = Math.random();
	// }
}																																																																																																																																																																																																																																																																																																																																																																																																																							