/*
 * davidalves.net presents:
 * ________                  .__   .__           __      _____   .__                            _____           .__   
 * \______ \   __ __   ____  |  |  |__|  _______/  |_   /     \  |__|  ____  _______   ____    /     \    ____  |  |    ____    ____  
 *  |    |  \ |  |  \_/ __ \ |  |  |  | /  ___/\   __\ /  \ /  \ |  |_/ ___\ \_  __ \ /  _ \  /  \ /  \ _/ __ \ |  |  _/ __ \ _/ __ \ 
 *  |    `   \|  |  /\  ___/ |  |__|  | \___ \  |  |  /    Y    \|  |\  \___  |  | \/(  <_> )/    Y    \\  ___/ |  |__\  ___/ \  ___/ 
 * /_______  /|____/  \___  >|____/|__|/____  > |__|  \____|__  /|__| \___  > |__|    \____/ \____|__  / \___  >|____/ \___  > \___  >
 *         \/             \/                \/                \/          \/                         \/      \/            \/      \/ 
 * 
 * Version History:
 *  1.4: Improved survival and reduced codesize a bit using a clever trick from Troodon.
 *         Troodon is a very good bot by DrLoco that uses the same basic framework as DuelistMicroMelee.
 *         Hopefully we can continue to learn from each other's bots as they evolve.
 *  1.3: Added corner movement to prevent losing to DuelistNanoMelee, first microbot ever to have it! :-)
 *  1.2: Greatly enhanced 1-v-1 movement and reduced codesize.
 *  1.1: Reduced firepower. First version entered in Minibot Challenge.
 *  1.0: My first microbot! Originally based on DuelistMiniMelee.
 */

package davidalves.net;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;

import davidalves.net.util.mini.MicroScan;

import robocode.*;

public class DuelistMicroMelee extends TeamRobot{

	/* **********************        Declarations      ********************** */
	
	//Minimum distance from wall
	static final double wallMargin = 25.0;
	
	//How far from the corner our corner movement should be
	static final double cornerMargin = 125.0;
	
	//How long each movement should be, in ticks
	static final int movementTimer = 20;
		
	//All scanned enemies
	static Hashtable enemies;
		
	//Our current target
	static MicroScan target;
		
		
	/* **********************          Run            ********************** */		
	public void run() {
		
		/*
		 * 
		 * The original Duelist colors were
		 * 
		 * setColors(new Color(90, 90, 90), new Color(90, 90, 90), new Color(0, 200, 200));
		 * 
		 * but that's too big for a minibot so I've used the following ever since.
		 * 
		 */
		
		setColors(Color.darkGray, Color.darkGray, Color.cyan);
		
		//Clear scan data from last round
		enemies = new Hashtable();
		
		do {
			
			double destinationX, destinationY, searchAreaSize;
			double bestX = 0.0, bestY = 0.0, bestForce = Double.POSITIVE_INFINITY;
			double myX = getX(), myY = getY();
			boolean inCorner = (getOthers() > 1) && Math.abs(500.0 - myX) > 300.0 && Math.abs(500.0 - myY) > 300.0;
			
			setTurnRadarRightRadians(searchAreaSize = 160.0);
			
			/* ***********************     Fire Cannon       ********************** */
			
			try{
				
				//If our target dies, it will be removed from the Hashtable and this will set target
				//to null on the next turn.
				target = (MicroScan) enemies.get(target.name);
				
				//Aim directly at target
				setTurnGunRightRadians(Math.sin(target.absoluteBearing - getGunHeadingRadians()));
				
				if(getEnergy() > Math.min(3.0, target.energy))
					setFire(getEnergy() * 35.0 / target.distance);
				
				//In 1-v-1 we want our movement length to be based on the distance to our target.
				if(getOthers() == 1)
					searchAreaSize = target.distance * .7;
					
			
			} catch(Exception e){}
			
				
			/* ***********************      Drive Tank        ********************** */
			
			
			//If we're stopped, or we're doing corner movement, it's time to move.
			if(getVelocity() == 0.0 || inCorner){
				/*
				 * Test 200 randomly selected points around us to find which makes the best destination
				 * 
				 * Note that the resulting destination point will be ignored if we're using corner movement.
				 * 
				 * Doing the loop manually is a few bytes smaller than using for(...)
				 * Thanks to DrLoco for discovering this. :-)
				 */
				
				int i = 20;
				do{
					
					/*
					 * Select a random test point from a square centered on us. In melee the square is 
					 * 320x320, in duels it is (enemyDistance * 1.3) x (enemyDistance * 1.3). If the
					 * square extends off the edge of the field it is cropped so that we'll only test
					 * points that we can actually drive to. This same method of selecting random points
					 * to test is used in all Duelist bots except NanoDuelist.
					 */
					
					destinationX = random(
						//Minimum X
						Math.max(wallMargin, myX - searchAreaSize),
						//Maximum X
						Math.min(getBattleFieldWidth() - wallMargin, myX + searchAreaSize));
					destinationY = random(
						//Minimum Y
						Math.max(wallMargin, myY - searchAreaSize),
						//Maximum Y
						Math.min(getBattleFieldHeight() - wallMargin, myY + searchAreaSize));
					
				
					//Force represents the "badness" of our test point. We'll drive to the one with the lowest force.
					double force = 0;
					
					//Try to strafe our current target
					try{
						force = (Math.PI / 2.0  - Math.abs(Math.atan(Math.tan(Math.atan2(destinationX - myX, destinationY - myY) - target.absoluteBearing))));
					} catch(Exception e){}
					
					
					//Avoid the center of the battlefield in melee.
					if(getOthers() > 1)
						force = 500.0 / Point2D.Double.distance(destinationX, destinationY, getBattleFieldWidth() / 2.0, getBattleFieldHeight() / 2.0);
					
					Enumeration e = enemies.elements();
					
					while(e.hasMoreElements()){
						MicroScan enemy = (MicroScan) e.nextElement();
						force += 100.0 / Point2D.Double.distance(destinationX, destinationY, enemy.x, enemy.y);
					}
					
					
					if(force < bestForce){
						bestX = destinationX;
						bestY = destinationY;
						bestForce = force;
					}
				} while(i-- > 0);
				
				//Corner movement
				if(inCorner){
					bestY = 2.0 * wallMargin + cornerMargin - (bestX = wallMargin + cornerMargin * ((getTime() / movementTimer) % 2));
					
					if(myX > 500.0)
						bestX = 1000.0 - bestX;

					if(myY > 500.0)
						bestY = 1000.0 - bestY;
				
				}
				
				//destinationY now represents the angle to turn to. Re-using variables saves space! :-)
				//destinationX now represents the angle to turn to, normalized to between -90 and 90
				setTurnRightRadians(destinationY = Math.atan(Math.tan(destinationX = ((Math.atan2(bestX - myX, bestY - myY) - getHeadingRadians()) + (7.0 * Math.PI)) % (2.0 * Math.PI) - Math.PI)));
				
				/* 
				 * Sometimes Math.atan(Math.tan(x)) isn't exactly x, due to rounding errors. It 
				 * seems to be a little less than once per round in an 800x600 duel. Thanks to 
				 * Dummy for teaching me about this. :-)
				 */
				
				setAhead((destinationX == destinationY ? 1.0 : -1.0) * Point2D.Double.distance(myX, myY, bestX, bestY));
			} 
			
			
			execute();
			
		} while (true);
	}
	
	/* **********************     Utility Function     ********************** */
	
	static double random(double min, double max){
		return Math.random() * (max - min) + min;
	}
	
	/* **********************    Event Handlers      ********************** */
	
	public void onScannedRobot(ScannedRobotEvent e) {

		MicroScan temp = (MicroScan) enemies.get(e.getName());
		
		if(temp == null)
			temp = new MicroScan();
		
		//Not very clean, but this is the most efficient way to set x, y, distance, and bearing I've found so far.
		double distance, absoluteBearing;
		temp.x = getX() + Math.sin(absoluteBearing = temp.absoluteBearing = e.getBearingRadians() + getHeadingRadians() + 4.0 * Math.PI % (Math.PI * 2.0)) * (distance = temp.distance = e.getDistance());
		temp.y = getY() + Math.cos(absoluteBearing) * (distance);
		
		if(target == null || distance < target.distance){
			target = temp;
		}
		
		enemies.put((temp.name = e.getName()), temp);
	}
	
	public void onRobotDeath(RobotDeathEvent e){
		enemies.remove(e.getName());
	}
}
