package maribo.utils;

import java.awt.geom.Point2D;
import java.util.ArrayList;

import robocode.util.*;
import robocode.*;

/* 
 * This is Future Position by Albert.
 * I took it from the page on the wiki and
 * modified it slightly as needed by my use of it.
 * Thank-you very much to Albert for sharing this
 * code with the Robocode community.
 */

public class MoveSim {

	private double systemMaxTurnRate = Math.toRadians(10.0);
	private double systemMaxVelocity = 8.0;
	private double maxBraking = 2.0;
	private double maxAcceleration = 1.0;

	public double defaultMaxTurnRate = 10.0;
	public double defaultMaxVelocity = 8.0;
	
	public boolean hitWall = false;

	public MoveSim() {};


	/*public MoveSimStat[] futurePos(int steps, AdvancedRobot b) {
		return futurePos(steps, b, defaultMaxVelocity, defaultMaxTurnRate);
	}

	public MoveSimStat[] futurePos(int steps, AdvancedRobot b, double maxVel, double maxTurnRate) {
		return futurePos(steps, b.getX(), b.getY(), b.getVelocity(), maxVel, b.getHeadingRadians(),
				b.getDistanceRemaining(), b.getTurnRemainingRadians(), maxTurnRate,
				b.getBattleFieldWidth(), b.getBattleFieldHeight());
	}

	public MoveSimStat[] futurePos(int steps, double x, double y, double velocity, double maxVelocity,
			double heading, double distanceRemaining, double angleToTurn, double maxTurnRate,
			double battleFieldW, double battleFieldH) {
		//maxTurnRate in degrees
		MoveSimStat[] pos = new MoveSimStat[steps];
		double acceleration = 0;
		boolean slowingDown = false;
		double moveDirection;

		maxTurnRate = Math.toRadians(maxTurnRate);
		if (distanceRemaining == 0) moveDirection = 0;
		else if (distanceRemaining < 0.0) moveDirection = -1;
		else moveDirection = 1;

		//heading, accel, velocity, distance
		for (int i = 0; i < steps; i++) {
			//heading
			double lastHeading = heading;
			double turnRate = M.min(maxTurnRate, ((0.4 + 0.6 * (1.0 - (M.abs(velocity) / systemMaxVelocity))) * systemMaxTurnRate));
			if (angleToTurn > 0.0) {
				if (angleToTurn < turnRate) {
					heading += angleToTurn;
					angleToTurn = 0.0;
				} 
				else {
					heading += turnRate;
					angleToTurn -= turnRate;
				}
			} else if (angleToTurn < 0.0) {
				if (angleToTurn > -turnRate) {
					heading += angleToTurn;
					angleToTurn = 0.0;
				} 
				else {
					heading -= turnRate;
					angleToTurn += turnRate;
				}
			}
			heading = Utils.normalAbsoluteAngle(heading);
			//movement
			if (distanceRemaining != 0.0 || velocity != 0.0) {
				if (!slowingDown && moveDirection == 0) {
					slowingDown = true;
					if (velocity > 0.0) moveDirection = 1;
					else if (velocity < 0.0) moveDirection = -1;
					else moveDirection = 0;
				}
				double desiredDistanceRemaining = distanceRemaining;
				if (slowingDown) {
					if (moveDirection == 1 && distanceRemaining < 0.0) desiredDistanceRemaining = 0.0;
					else if (moveDirection == -1 && distanceRemaining > 1.0) desiredDistanceRemaining = 0.0;
				}
				double slowDownVelocity	= (double) (int) (maxBraking / 2.0 * ((M.sqrt(4.0 * M.abs(desiredDistanceRemaining) + 1.0)) - 1.0));
				if (moveDirection == -1) slowDownVelocity = -slowDownVelocity;
				if (!slowingDown) {
					if (moveDirection == 1) {
						if (velocity < 0.0) acceleration = maxBraking;
						else acceleration = maxAcceleration;
						if (velocity + acceleration > slowDownVelocity) slowingDown = true;
					} else if (moveDirection == -1) {
						if (velocity > 0.0) acceleration = -maxBraking;
						else acceleration = -maxAcceleration;
						if (velocity + acceleration < slowDownVelocity)	slowingDown = true;
					}
				}
				if (slowingDown) {
					if (distanceRemaining != 0.0 && M.abs(velocity) <= maxBraking
							&& M.abs(distanceRemaining) <= maxBraking) slowDownVelocity = distanceRemaining;
					double perfectAccel = slowDownVelocity - velocity;
					if (perfectAccel > maxBraking) perfectAccel = maxBraking;
					else if (perfectAccel < -maxBraking) perfectAccel = -maxBraking;
					acceleration = perfectAccel;
				}
				if (velocity > maxVelocity || velocity < -maxVelocity) acceleration = 0.0;
				velocity += acceleration;
				if (velocity > maxVelocity)	velocity -= M.min(maxBraking, velocity - maxVelocity);
				if (velocity < -maxVelocity) velocity += M.min(maxBraking, -velocity - maxVelocity);
				double dx = velocity * M.sin(heading);
				double dy = velocity * M.cos(heading);
				x += dx;
				y += dy;
				if (slowingDown && velocity == 0.0) {
					distanceRemaining = 0.0;
					moveDirection = 0;
					slowingDown = false;
					acceleration = 0.0;
				}
				distanceRemaining -= velocity;
				if (x < 18 || y < 18 || x > battleFieldW-18 || y > battleFieldH-18) {
					distanceRemaining = 0;
					angleToTurn = 0;
					velocity = 0;
					moveDirection = 0;
					x = M.max(18, M.min(battleFieldW-18, x));
					y = M.max(18, M.min(battleFieldH-18, y));
				}
			}
			//add position
			pos[i] = new MoveSimStat(x, y, velocity, heading, Utils.normalRelativeAngle(heading-lastHeading));
		}
		return pos;		
	}*/
	
	public MoveSimStat[] futurePos(int steps, double x, double y, double velocity, double lowMaxVel,
			double changeMaxVel, double highMaxVel, double heading, double distanceRemaining,
			double angleToTurn, double maxTurnRate, double battleFieldW, double battleFieldH) {
		//maxTurnRate in degrees
		MoveSimStat[] pos = new MoveSimStat[steps];
		double acceleration = 0;
		boolean slowingDown = false;
		double moveDirection;

		maxTurnRate = Math.toRadians(maxTurnRate);
		if (distanceRemaining == 0) moveDirection = 0;
		else if (distanceRemaining < 0.0) moveDirection = -1;
		else moveDirection = 1;

		//heading, accel, velocity, distance
		for (int i = 0; i < steps; i++) {
			//heading
			double lastHeading = heading;
			double turnRate = M.min(maxTurnRate, ((0.4 + 0.6 * (1.0 - (M.abs(velocity) / systemMaxVelocity))) * systemMaxTurnRate));
			if (angleToTurn > 0.0) {
				if (angleToTurn < turnRate) {
					heading += angleToTurn;
					angleToTurn = 0.0;
				} 
				else {
					heading += turnRate;
					angleToTurn -= turnRate;
				}
			} else if (angleToTurn < 0.0) {
				if (angleToTurn > -turnRate) {
					heading += angleToTurn;
					angleToTurn = 0.0;
				} 
				else {
					heading -= turnRate;
					angleToTurn += turnRate;
				}
			}
			heading = Utils.normalAbsoluteAngle(heading);
			//movement
			if (distanceRemaining != 0.0 || velocity != 0.0) {
				if (!slowingDown && moveDirection == 0) {
					slowingDown = true;
					if (velocity > 0.0) moveDirection = 1;
					else if (velocity < 0.0) moveDirection = -1;
					else moveDirection = 0;
				}
				double desiredDistanceRemaining = distanceRemaining;
				if (slowingDown) {
					if (moveDirection == 1 && distanceRemaining < 0.0) desiredDistanceRemaining = 0.0;
					else if (moveDirection == -1 && distanceRemaining > 1.0) desiredDistanceRemaining = 0.0;
				}
				double slowDownVelocity	= (double) (int) (maxBraking / 2.0 * ((M.sqrt(4.0 * M.abs(desiredDistanceRemaining) + 1.0)) - 1.0));
				if (moveDirection == -1) slowDownVelocity = -slowDownVelocity;
				if (!slowingDown) {
					if (moveDirection == 1) {
						if (velocity < 0.0) acceleration = maxBraking;
						else acceleration = maxAcceleration;
						if (velocity + acceleration > slowDownVelocity) slowingDown = true;
					} else if (moveDirection == -1) {
						if (velocity > 0.0) acceleration = -maxBraking;
						else acceleration = -maxAcceleration;
						if (velocity + acceleration < slowDownVelocity)	slowingDown = true;
					}
				}
				if (slowingDown) {
					if (distanceRemaining != 0.0 && M.abs(velocity) <= maxBraking
							&& M.abs(distanceRemaining) <= maxBraking) slowDownVelocity = distanceRemaining;
					double perfectAccel = slowDownVelocity - velocity;
					if (perfectAccel > maxBraking) perfectAccel = maxBraking;
					else if (perfectAccel < -maxBraking) perfectAccel = -maxBraking;
					acceleration = perfectAccel;
				}
				double maxVelocity = M.abs(angleToTurn) > changeMaxVel ? lowMaxVel : highMaxVel;
				if (velocity > maxVelocity || velocity < -maxVelocity) acceleration = 0.0;
				velocity += acceleration;
				if (velocity > maxVelocity)	velocity -= M.min(maxBraking, velocity - maxVelocity);
				if (velocity < -maxVelocity) velocity += M.min(maxBraking, -velocity + maxVelocity);
				double dx = velocity * M.sin(heading);
				double dy = velocity * M.cos(heading);
				x += dx;
				y += dy;
				if (slowingDown && velocity == 0.0) {
					distanceRemaining = 0.0;
					moveDirection = 0;
					slowingDown = false;
					acceleration = 0.0;
				}
				distanceRemaining -= velocity;
			}
			//add position
			pos[i] = new MoveSimStat(x, y, velocity, heading, Utils.normalRelativeAngle(heading-lastHeading));
		}
		return pos;		
	}

	public ArrayList<MoveSimStat> futurePos(Point2D.Double end, int endDist, Point2D.Double current, double velocity,
			double lowMaxVel, double changeMaxVel, double highMaxVel, double heading, double maxTurnRate,
			double battleFieldW, double battleFieldH) {
		//maxTurnRate in degrees
		ArrayList<MoveSimStat> posA = new ArrayList<MoveSimStat>();
		double acceleration = 0;
		boolean slowingDown = false;
		double angle = Utils.normalRelativeAngle(calcAngle(end, current) - heading);
		double angleLeft = Math.atan(Math.tan(angle));
		double distLeft = current.distance(end) * (angle == angleLeft ? 1 : -1);
		double moveDirection = M.signum(distLeft);

		maxTurnRate = Math.toRadians(maxTurnRate);

		//heading, accel, velocity, distance
		while (M.abs(distLeft) > endDist) {
			//heading
			double lastHeading = heading;
			double turnRate = M.min(maxTurnRate, ((0.4 + 0.6 * (1.0 - (M.abs(velocity) / systemMaxVelocity))) * systemMaxTurnRate));
			if (angleLeft > 0.0) {
				if (angleLeft < turnRate) {
					heading += angleLeft;
					angleLeft = 0.0;
				} 
				else {
					heading += turnRate;
					angleLeft -= turnRate;
				}
			} else if (angleLeft < 0.0) {
				if (angleLeft > -turnRate) {
					heading += angleLeft;
					angleLeft = 0.0;
				} 
				else {
					heading -= turnRate;
					angleLeft += turnRate;
				}
			}
			heading = Utils.normalAbsoluteAngle(heading);
			//movement
			if (distLeft != 0.0 || velocity != 0.0) {
				if (!slowingDown && moveDirection == 0) {
					slowingDown = true;
					if (velocity > 0.0) moveDirection = 1;
					else if (velocity < 0.0) moveDirection = -1;
					else moveDirection = 0;
				}
				double desiredDistanceRemaining = distLeft;
				if (slowingDown) {
					if (moveDirection == 1 && distLeft < 0.0) desiredDistanceRemaining = 0.0;
					else if (moveDirection == -1 && distLeft > 1.0) desiredDistanceRemaining = 0.0;
				}
				double slowDownVelocity	= (double) (int) (maxBraking / 2.0 * ((M.sqrt(4.0 * M.abs(desiredDistanceRemaining) + 1.0)) - 1.0));
				if (moveDirection == -1) slowDownVelocity = -slowDownVelocity;
				if (!slowingDown) {
					if (moveDirection == 1) {
						if (velocity < 0.0) acceleration = maxBraking;
						else acceleration = maxAcceleration;
						if (velocity + acceleration > slowDownVelocity) slowingDown = true;
					} else if (moveDirection == -1) {
						if (velocity > 0.0) acceleration = -maxBraking;
						else acceleration = -maxAcceleration;
						if (velocity + acceleration < slowDownVelocity)	slowingDown = true;
					}
				}
				if (slowingDown) {
					if (distLeft != 0.0 && M.abs(velocity) <= maxBraking
							&& M.abs(distLeft) <= maxBraking) slowDownVelocity = distLeft;
					double perfectAccel = slowDownVelocity - velocity;
					if (perfectAccel > maxBraking) perfectAccel = maxBraking;
					else if (perfectAccel < -maxBraking) perfectAccel = -maxBraking;
					acceleration = perfectAccel;
				}
				double maxVelocity = M.abs(angleLeft) > changeMaxVel ? lowMaxVel : highMaxVel;
				if (velocity > maxVelocity || velocity < -maxVelocity) acceleration = 0.0;
				velocity += acceleration;
				if (velocity > maxVelocity)	velocity -= M.min(maxBraking, velocity - maxVelocity);
				if (velocity < -maxVelocity) velocity += M.min(maxBraking, -velocity - maxVelocity);
				current = calcPos(current, velocity, heading);
				if (slowingDown && velocity == 0.0) {
					distLeft = 0.0;
					moveDirection = 0;
					slowingDown = false;
					acceleration = 0.0;
				}
				distLeft -= velocity;
				//System.out.println(velocity + "  " + distLeft);
				if (current.x < 18 || current.y < 18 || current.x > battleFieldW-18 || current.y > battleFieldH-18) {
					distLeft = 0;
					angleLeft = 0;
					velocity = 0;
					moveDirection = 0;
					current.x = M.max(18, M.min(battleFieldW-18, current.x));
					current.y = M.max(18, M.min(battleFieldH-18, current.y));
					hitWall = true;
				}
			}
			//add position
			posA.add(new MoveSimStat(current, velocity, heading, Utils.normalRelativeAngle(heading-lastHeading)));
		}
		return posA;
	}
	
	private static Point2D.Double calcPos(Point2D.Double loc, double distance, double bearing) {
		return new Point2D.Double(loc.x + distance * M.sin(bearing), loc.y + distance * M.cos(bearing));
	}
	private static double calcAngle(Point2D.Double p2, Point2D.Double p1){
		return M.atan2(p2.x - p1.x, p2.y - p1.y);
	}
}