package simonton.micro;

import robocode.*;
import robocode.util.*;

/**
 * Tonight, after playing with random movement with almost no progress, I just
 * decided to make a tradition guess-factor, visit-count-stats micro bot. It's
 * movement is lifted straight from WeeklongObsession.
 * 
 * More details can be found at: http://robowiki.net/?GFMicro
 * 
 * @author Eric Simonton
 */
public class GFMicro extends AdvancedRobot {

	private static final double MAX_RETREAT = 45 * Math.PI / 180;
	private static final double WALL_CORRECT = 1 * Math.PI / 180;
	private static final double MAX_ATTACK = 45 * Math.PI / 180;
	private static final int WALKING_STICK_LENGTH = 120;
	private static final double TARGET_DISTANCE = 600;
	private static final int MOVE_LENGTH = 48;

	private static final int MIDDLE = 35;
	private static final int BINS = 2 * MIDDLE + 1;
	private static final int VELOCITY_SEGMENTS = 9;
	private static final int BULLET_POWER_SEGMENTS = 4;
	private static final int BULLET_POWER_FACTOR = 900;
	private static final int WALL_DISTANCE_SEGMENTS = 2;

	private static int random;
	private static double damage;
	private static double oDir = 1;
	private static double enemyEnergy;
	private static double enemyFireSpeed;

	private static double[][][][][] segments =
		new double[VELOCITY_SEGMENTS][VELOCITY_SEGMENTS][WALL_DISTANCE_SEGMENTS][BULLET_POWER_SEGMENTS][BINS];
	static double lastEVel;
	static double lastEHead;
	static int eODir;
	static int lastELatV;

	public void run() {

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		do {
			turnRadarRightRadians(1);
		} while (true);
	}

	// r1this; // 8
	public void onScannedRobot(ScannedRobotEvent r2e) { // 5

		int r3i; // 8
		double r4d; // 15
		double d; // 6
		double a; // 5

		int i; // 4 - 1 = 3
		double latV; // 2
		double bulletPower; // 3
		Wave wave; // 8

		double localODir; // 4
		double clockDist; // 2
		double flipProb; // 3
		double flipMod; // 3

		// ---------------------------------------------------------------- gun

		a = r4d = r2e.getBearingRadians() + this.getHeadingRadians();
		this.setTurnRadarRightRadians(2 * Utils.normalRelativeAngle(r4d
			- this.getRadarHeadingRadians()));

		addCustomEvent(wave =
			new Wave(Rules.getBulletSpeed(bulletPower =
				Math.min(Math.min(
					BULLET_POWER_FACTOR / (d = r2e.getDistance()),
					getEnergy() / 16), 3))));
		wave.stats =
			segments[lastELatV][lastELatV =
				Math.abs((int) (latV =
					(lastEVel = r2e.getVelocity())
						* Math.sin((lastEHead = r2e.getHeadingRadians())
							- (wave.angle = r4d))))][isOut(d, r4d
				+ (wave.oDir =
					eODir = Double.compare(latV + Math.toRadians(eODir), 0))
				/ 2.0)][(int) Math.rint(bulletPower)];

		r3i = 3 * BINS / 4;
		try {
			i = 0;
			do {
				if (wave.stats[i] > wave.stats[r3i]) {
					r3i = i;
				}
				++i;
			} while (true);
		} catch (ArrayIndexOutOfBoundsException ex) {}
		setTurnGunRightRadians(Utils.normalRelativeAngle(r4d
			- getGunHeadingRadians()
			+ eODir
			* (r3i - MIDDLE)
			* BIN_TO_ANGLE));
		setFire(bulletPower);

		// ----------------------------------------------------------- movement

		// calculate probability of flipping next turn.
		flipProb = 2.5 * enemyFireSpeed / (wave.distance = d);
		flipMod =
			1
				- Math.abs(clockDist =
					Utils.normalRelativeAngle(Math.atan2((this.getX() + d
						* Math.sin(r4d))
						- (BATTLEFIELD_WIDTH / 2), (this.getY() + d
						* Math.cos(r4d))
						- (BATTLEFIELD_HEIGHT / 2))
						- r4d))
				/ (Math.PI * 4);

		// calculate our angle of travel.
		// r3i = 0;
		// r3i = 1;
		r3i = random;
		r4d = Math.PI / 2 - 15 * Math.PI / 180;
		if (r3i > 0) {
			r4d =
				Math.max(Math.PI / 2 - MAX_RETREAT, d
					* ((Math.PI / 2) / (TARGET_DISTANCE - 40)));
		}
		while (isOut(-WALKING_STICK_LENGTH, a
			+ (localODir = oDir)
			* (r4d = r4d + WALL_CORRECT)) != 0)
			;

		// decide if we flip next turn.
		if (r4d > Math.PI - MAX_ATTACK
			|| (r3i > 0 && Math.random() < (clockDist * localODir > 0 ? flipMod
				* flipProb : 1 - flipMod * (1 - flipProb)))) {
			oDir = -localODir;
		}

		// move!
		this.setTurnRightRadians(Math.tan(r4d =
			a + localODir * r4d - this.getHeadingRadians()));
		if (enemyEnergy > (enemyEnergy = r2e.getEnergy()) || r3i > 0) {
			this.setAhead(Math.cos(r4d) * -MOVE_LENGTH);
		}
	}

	static class Wave extends Condition {

		int oDir;
		double speed;
		double angle;
		double distance;
		double[] stats;

		double gfMove;
		double travel;

		Wave(double speed) {

			this.speed = speed;
		}

		public boolean test() {

			double r2d;
			double r4d;

			angle =
				(r4d = angle)
					+ (r2d =
						Math.atan2(
							lastEVel * Math.sin(r2d = lastEHead - r4d),
							distance = distance + (lastEVel * Math.cos(r2d))));
			gfMove = gfMove + r2d;

			if (Math.abs((travel = travel + (r2d = speed))
				+ (r2d = r2d / 2)
				- distance) <= r2d) {
				++stats[MIDDLE + oDir * (int) (gfMove * ANGLE_TO_BIN)];
			}
			return false;
		}
	}

	public void onBulletHit(BulletHitEvent e) {

		enemyEnergy -= Rules.getBulletDamage(e.getBullet().getPower());
	}

	public void onHitByBullet(HitByBulletEvent e) {

		int round;
		enemyFireSpeed = e.getVelocity();
		if ((damage = damage + e.getPower()) > 9 * (round = getRoundNum())) {
			random = round / 3;
		}
		// System.out.println(damage + " >? " + (9 * round));
	}

	private int isOut(double distance, double angle) {

		try {
			return xOutTable
				.charAt(((int) (getX() + distance * Math.sin(angle))))
				| yOutTable
					.charAt(((int) (getY() + distance * Math.cos(angle))));
		} catch (StringIndexOutOfBoundsException ex) {
			return 1;
		}
	}

	private static final int BATTLEFIELD_WIDTH = 800;
	private static final String xOutTable =
		"\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1";

	private static final int BATTLEFIELD_HEIGHT = 600;
	private static final String yOutTable =
		"\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1";

	private static final double ANGLE_TO_BIN = 0.814339942 * (MIDDLE - 1);
	private static final double BIN_TO_ANGLE = 1 / ANGLE_TO_BIN;
	// private static final int MAX_DISTANCE = 950;
	// private static final int DISTANCE_SLICER = MAX_DISTANCE /
	// DISTANCE_SEGMENTS;
}
