package jwst.DAD.SpecialRobots;

import java.awt.*;

import robocode.*;

import jwst.DAD.Scanning.*;
import jwst.DAD.Movement.*;

/*********************************************************************************************
 * 
 * So basically, we made two separate classes for our robot: one that handles the melee 
 * and one that handles the one v one. This the class that handles all the melee events. Most
 * of the actual code, however, is in the AntiGravity/GuessFactorTargeting classes.
 * 
 * @author Jared Wong
 * @author Shawn Thomas
 * @period Period 2
 * 
 **********************************************************************************************/

public class MeleeBot extends specializedRobot
{
    private jwst.DAD.Scanning.Scanner scanner;
    private AntiGravity anti;

    /**
     * A constructor to build a Melee Robot
     * 
     * @param robot - Pass an AdvancedRobot to control
     */
    public MeleeBot( AdvancedRobot robot )
    {
        // use the super constructor
        super( robot );
        // initiate a new anti-grav robot
        anti = new AntiGravity( this.robot );
        // initiate a new scanner
        scanner = new jwst.DAD.Scanning.Scanner(this.robot);
    }

    public void run()
    {
        // make all parts independent of each other
        robot.setAdjustRadarForGunTurn( true );
        robot.setAdjustRadarForRobotTurn( true );
        robot.setAdjustGunForRobotTurn( true );

        // initially run the anti-gravity movement robot
        anti.run();
        
        // run and execute continuously
        // must do the SAME EXACT things as the oneVone continuous method in run
        while ( true )
        {
            scanner.run();
            robot.execute();
        }
        
    }

    public void onScannedRobot( ScannedRobotEvent e )
    {
        anti.onScannedRobot( e );
    }
    
    public void onRobotDeath(RobotDeathEvent e)
    {
        System.out.println("RERU!! I AM DEAD :O");
    }
    
    public String toString()
    {
        return ("I'm a melee bot!");
    }
}
