package mbro;
import robocode.*;
import java.awt.Color;

/**
 * Detektor3 - a robot by (Amru Mubaidillah) 0.1.1
 */
public class Detektor3 extends AdvancedRobot
{
	static int BATAS = 150;
	static int BATAS_KIRI = BATAS;
	static int BATAS_ATAS;
	static int BATAS_KANAN;
	static int BATAS_BAWAH = BATAS;
	int besarSudut = 30;
	int lastScan = 0;

	//double radius;
	boolean onMove = false;
	ScannedRobotEvent scannedRobot;

	/**
	 * run: Detektor3's default behavior
	 */
	public void run() {
		BATAS_KANAN = (int)getBattleFieldWidth() - BATAS;
		BATAS_ATAS = (int)getBattleFieldHeight() - BATAS;

		addCustomEvent(
			new Condition ("nabrakTembok", 1) {
				public boolean test() {
					return ((getHeading() >= 270 || getHeading() < 90) && getY() >= BATAS_ATAS) ||
							((getHeading() >= 0 && getHeading() < 180) && getX() >= BATAS_KANAN) ||
							((getHeading() >= 90 && getHeading() < 270) && getY() <= BATAS_BAWAH) ||
							((getHeading() >= 180 && getHeading() <= 360) && getX() <= BATAS_KIRI);
				}
		}
		);

		setColors(Color.black,Color.black,Color.green);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		int i = 0;
		lastScan = 100;
		//radius = Math.random() * 100 + 100;

		while(true) {

			setAhead(Double.POSITIVE_INFINITY);
			if (lastScan++ > 1)
				setTurnRadarRight(Double.POSITIVE_INFINITY);
			setTurnLeft(Math.random() * 15);
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		lastScan = 0;
		scannedRobot = e;
		double target = (getHeading() + e.getBearing()) % 360;
		if (target < 0) target += 360;
		double sudut = target - getGunHeading();
		if ((sudut > 180) || (sudut < -180)) 
			setTurnGunRight(360 - Math.abs(sudut));
		else 
			setTurnGunRight(sudut);		
		if (getGunHeat() == 0)
		if (e.getDistance() < 50)
			setFire(3);
		else if (e.getDistance() < 100)
			setFire(2);
		else if (e.getDistance() < 150)
			setFire(1);
		else 
			setFire(.5);
		//execute();
		//hitung sudut
		//radar terhadap target
		double sudut2 = target - getRadarHeading();
		if (sudut2 > 180 || sudut2 <-180)
			if (sudut2 < 0)
			{
				setTurnRadarLeft(360 - Math.abs(sudut2) + besarSudut / 2);
			} else
				setTurnRadarRight(360 - Math.abs(sudut2) + besarSudut / 2);
		else
			if (sudut2 < 0)
				setTurnRadarLeft(Math.abs(sudut2) + besarSudut / 2);
			else
				setTurnRadarRight(sudut2 + besarSudut / 2);
	}

	/**
	 * onCustomEvent: hindari tembok
	 */
	public void onCustomEvent(CustomEvent e) {
		if (e.getCondition().getName().equals("nabrakTembok"))
			setTurnRight(getHeading() %90);

	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		//arahkan radar ke musuh
	}
	
	/**
	 * onHitRobot:  Turn to face robot, fire hard, and ram him again!
	 */
	public void onHitRobot(HitRobotEvent e) {
		if (e.getBearing() < 180 || e.getBearing() > 180) {
			//setAdjustGunForRobotTurn(false);
			turnRight(e.getBearing());
			fire(3);
			ahead(4);
			//setAdjustGunForRobotTurn(true);
		} 
	}
}
