package ph.micro;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;

public class Pikeman extends AdvancedRobot {
    
    static final double REVERSE_TUNER = 0.421075;
    static final double WALL_BOUNCE_TUNER = 0.699484;
    static final double firePower=1.9;
    static final double bulletSpeed=/*20-3*firePower*/14.3;
    static final double escapeAngle=/*Math.asin(8/bulletSpeed)*/0.593710702860275;
    static Point2D robotLocation;
    static Point2D enemyLocation;
    
    static int enemyDirection;
    
    static double enemyAbsoluteBearing;
    static double enemyDistance;
    static double enemyVelocity;
    static double lastEnemyVelocity;
    static double movementLateralAngle = 0.2;
    static double enemyBulletSpeed=20;
    static long accelerationTimer;
    
    static int[][][][][][] guessFactors;
    
    static {
        guessFactors=new int[6][5][5][6][2][27];
    }
    
    public void run() {
        setAdjustRadarForGunTurn(true);
        setAdjustGunForRobotTurn(true);
        for(;;) {
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }
    
    public void onHitByBullet(HitByBulletEvent evt) {
        enemyBulletSpeed = 20 - 3*evt.getPower();
    }
    
    public void onScannedRobot(ScannedRobotEvent e) {
        enemyLocation = vectorToLocation((enemyAbsoluteBearing= getHeadingRadians() + e.getBearingRadians()), (enemyDistance=e.getDistance()), (robotLocation= new Point2D.Double(getX(), getY())));
        if(e.getVelocity()!=enemyVelocity)    
            accelerationTimer = 0;
        lastEnemyVelocity = enemyVelocity;
        if ((enemyVelocity=e.getVelocity()) != 0) {
            enemyDirection = Math.sin(e.getHeadingRadians()-enemyAbsoluteBearing)*enemyVelocity < 0 ? -1 : 1;
        }
        
        RoundRectangle2D fieldRectangle = new RoundRectangle2D.Double(25, 25,
        750, 550, 75, 75);
        int[] stats=guessFactors[(int)Math.min(5,enemyDistance/160)][(int)Math.abs(enemyVelocity)/2][(int)Math.abs(lastEnemyVelocity)/2][(int)Math.min(5, accelerationTimer++/13)][fieldRectangle.contains(vectorToLocation(e.getHeadingRadians(), enemyVelocity, enemyLocation)) ? 0 : 1];
        int bestindex = 13;/*(stats.length-1)/2;*/	//initialize it to be in the middle, guessfactor 0.
        for (int i=0; i<27; i++)
            if (stats[bestindex] < stats[i])
                bestindex = i;
        
        setTurnGunRightRadians(Utils.normalRelativeAngle((enemyAbsoluteBearing+((double)enemyDirection*((double)((2d*(double)bestindex)/((double)/*stats.length-1d*/26))-1d)*escapeAngle))-getGunHeadingRadians()));
        setFire(firePower);
        
        addCustomEvent(new Wave(stats));
        
        Point2D robotDestination;
        double tries = 0;
        while (!fieldRectangle.contains(robotDestination = vectorToLocation(enemyAbsoluteBearing + Math.PI + movementLateralAngle,
		Math.max(80,enemyDistance) * (1.2 - tries / 100.0),enemyLocation)) && tries++ < 100) {
	}
        
        if (Math.random() < (enemyBulletSpeed / REVERSE_TUNER) / enemyDistance
        || tries > (enemyDistance / enemyBulletSpeed / WALL_BOUNCE_TUNER)) {
            movementLateralAngle = - movementLateralAngle;
        }
        
        // Jamougha's cool way
	double angle;
	setAhead(Math.cos(angle = absoluteBearing(robotLocation, robotDestination) - getHeadingRadians()) * 100);
	setTurnRightRadians(Math.tan(angle));
        
        setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getRadarHeadingRadians()));
    }
    
    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
        sourceLocation.getY() + Math.cos(angle) * length);
    }
    
    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
    
    private class Wave extends Condition {
        private Point2D launchLocation;
        private long launchTime;
        private double heading;
        private double direction;
        private int[] returnSegment;
        
        public Wave(int[] returnSegment) {
            launchLocation=robotLocation;
            launchTime=getTime();
            heading=enemyAbsoluteBearing;
            direction=enemyDirection;
            this.returnSegment = returnSegment;
        }
        
        public boolean test() {
            //if the distance from the wave origin to our enemy has passed the distance the bullet would have traveled...
            if (launchLocation.distance(enemyLocation) <= (getTime()-launchTime)*bulletSpeed) {
                returnSegment[(int)Math.round(((/*returnSegment.length-1*/26)*((Math.max(-1, Math.min(1, (Utils.normalRelativeAngle(absoluteBearing(launchLocation,enemyLocation)-heading))/escapeAngle))*direction)+1))/2)]++;
                removeCustomEvent(this);
            }
            return false;
        }
        
    }
    
}
