package gg;
import robocode.*;
import java.util.*;
import java.lang.*;

//Classe che identifica un nemico
	class Nemico {
		public String name;
		public String debug;
		public double energy,bearing,distance,heading,velocity,X,Y;
		private double PI=Math.PI;
		public long lastScan;
		// Lunghezza coda movimenti
		private long codaMovLen=8;
		//Elenco movimenti
		public TreeMap Movimenti=new TreeMap();
		
		public Nemico(ScannedRobotEvent e,double currX,double currY,double HeadingRadians,long lastScan) {
			this.name=e.getName();
			this.energy=e.getEnergy();
			this.bearing=e.getBearing();
			this.distance=e.getDistance();
			this.heading=e.getHeading();
			this.velocity=e.getVelocity();
			this.lastScan=lastScan;
			double absbearing_rad = (HeadingRadians+e.getBearingRadians())%(2*PI);
			this.X=currX+Math.sin(absbearing_rad)*e.getDistance();
			this.Y=currY+Math.cos(absbearing_rad)*e.getDistance();
		}
		
		public void refresh(ScannedRobotEvent e,double currX,double currY,double HeadingRadians,long lastScan) {
			// Aggiornamento coda movimenti
			if(Movimenti.isEmpty()) {
				Movimenti.put(new Long(lastScan),new Movimento(this.X,this.Y,currX,currY,lastScan));
			}
			else {
				Movimenti.put(new Long(lastScan),new Movimento(this.X,this.Y,currX,currY,lastScan));
				// Rimuovo se occorre il pi vecchio
				while (Movimenti.size()>codaMovLen) {
					Movimenti.remove(Movimenti.firstKey());
				}
			}
			// Aggiornamento dati
			this.energy=e.getEnergy();
			this.bearing=e.getBearing();
			this.distance=e.getDistance();
			this.heading=e.getHeading();
			this.velocity=e.getVelocity();
			this.lastScan=lastScan;
			double absbearing_rad = (HeadingRadians+e.getBearingRadians())%(2*PI);
			this.X=currX+Math.sin(absbearing_rad)*e.getDistance();
			this.Y=currY+Math.cos(absbearing_rad)*e.getDistance();
		}
		
		public boolean isUpdated(long Tempo) {
			if((Tempo-this.lastScan)<16)
				return true;
			else
				return false;
		}
		
		public double guessX(long when) {
    	long diff = when - lastScan;
			if(Movimenti.size()>0)
				return X+Math.sin(heading)*(getDeltaX()/getTime())*diff;
			else
        return X+Math.sin(heading)*velocity*diff;
    }
		
    public double guessY(long when) {
    	long diff = when - lastScan;
			if(Movimenti.size()>0)
				return Y+Math.cos(heading)*(getDeltaY()/getTime())*diff;
			else
				return Y+Math.cos(heading)*velocity*diff;
    }
		
		private double getTime() {
			Movimento movAttuale;
			long tempo=0;
			
			Iterator coreIter =Movimenti.values().iterator();
			while(coreIter.hasNext()) {
				movAttuale=(Movimento)coreIter.next();
				tempo=tempo+movAttuale.tempo;
			}
			tempo=tempo/Movimenti.size();
			return tempo;
		}
		
		private double getDeltaX() {
			Movimento movAttuale;
			double DeltaX=0;
			long tempoTot=0;
			
			Iterator coreIter =Movimenti.values().iterator();
			while(coreIter.hasNext()) {
				movAttuale=(Movimento)coreIter.next();
				DeltaX=DeltaX+(movAttuale.deltaX()*movAttuale.tempo);
				tempoTot=tempoTot+movAttuale.tempo;
			}
			DeltaX=DeltaX/(tempoTot);
			return DeltaX;
		}
		
		private double getDeltaY() {
			Movimento movAttuale;
			double DeltaY=0;
			long tempoTot=0;
			
			Iterator coreIter =Movimenti.values().iterator();
			while(coreIter.hasNext()) {
				movAttuale=(Movimento)coreIter.next();
				DeltaY=DeltaY+(movAttuale.deltaY()*movAttuale.tempo);
				tempoTot=tempoTot+movAttuale.tempo;
			}
			DeltaY=DeltaY/(tempoTot);
			return DeltaY;
		}
	}
