package ar.horizon.util;

import java.awt.geom.Point2D;

/**
 * Structure of the information generated by precise prediction.
 * 
 * @author Aaron Rotenberg
 */
public class PredictedState {
	private final Point2D.Double location;
	private final double velocity;
	private final double heading;
	private final int ticks;

	public PredictedState(RobotRecording recording) {
		this(recording.getLocation(), recording.getVelocity(),
				recording.getHeading(), 0);
	}

	public PredictedState(Point2D.Double location, double velocity,
			double heading, int ticks) {
		this.location = location;
		this.velocity = velocity;
		this.heading = heading;
		this.ticks = ticks;
	}

	public Point2D.Double getLocation() {
		return location;
	}

	public double getVelocity() {
		return velocity;
	}

	public double getHeading() {
		return heading;
	}

	public int getTicks() {
		return ticks;
	}
}
