package robar.nano;
import robocode.*;
import robocode.util.*;
import java.awt.*;

public class BlackWidow extends AdvancedRobot{

	//Made by HUNRobar
	//You can contact me at testwiki.roborumble.org, or via e-mail to robar06@gmail.com
	//Credits: for the whole wiki community! Especially for Simonton's WeekendObsession and thanks to NeophytePattern for precalculated bullet-flight-time trick.
	
	/*VERSION HISTORY:
	 * 1.25 - With WeekendObsession's gun, rounded lateral velocities, improved starting log, nice colors, stopNgo death limit is 2 instead of 3
	 * 
	 * 1.2 - Turned back to original random movement, kept setAdjust but left out distance-control. Little energy management added.
	 * 
	 * 1.15 - Simplified distance-control, normal BFTIME prediction redone. 
	 * 
	 * 1.1 - Replaced the gun with WeekendObsession's. Managed to add distance-control and setAdjustGun. 2 days of hard code-squeezing work. (:^
	 *
	 * 1.0 - StopNGO plus Random movement, FunkyChicken's gun.
	 */
    //Global   
    static String enemyLog = "000000000000000000000000000000888888888888888765432100888765432101234567888765432100"; //The list where enemy lateral velocities are stored

    //Constants
    static final double FIREPOWER = 2.5; //The firepower of the bot
    static final double BULLETVEL = 20-3*FIREPOWER; //The velocity of the bullet fired at FIREPOWER
    static final int PATTERN_DEPTH = 30; //The length of the pattern we try to find each turn in enemyLog
    static final double MOVEAMOUNT = 37.0; //The amount of pixels the bot will move in stop and go
    static final int DEATHLIMIT = 1; //Do StopNGo until 2 deaths
    //static final int FPFACTOR = 5;
    //static final double AANGLE = 0.2;
    //static final double PLUSANGLEMULTI = 5.0; //The sign of distance-controlling turn divided by this equals the turn amount in radians e.g. 0.2 of -0.2
    //static final double DISTANCE = 250.0; //The distance-control tries to drive the bot to this distance from the enemy
    //static final int BFTIME = (int)(DISTANCE / BULLETVEL);  //The bullet-flight time precalculated. It's working because of the distance-control. Credits to NeophytePattern for this squeezing idea.

    //Variables
    static double prevEnergy; //It stores the energy of the enemy
    static double direction = MOVEAMOUNT; //It's the direction and the movement packed together
    static int deathCount; //The number of deaths of our robot

    public void run(){
        //setAdjustGunForRobotTurn(true); //This sets the gun independent from the body.
    	//setAdjustRadarForGunTurn(true);
    	//Black Widow-like colors: ;)
    	//setAllColors(Color.black);
    	setColors(Color.black, Color.red, Color.black);
    	
        //Infinite radar-lock
        setTurnRadarRight(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e){

            //Local variables 
   		    int matchLenght = PATTERN_DEPTH; //the number of data a pattern contains, then the counter in the absB updater loop  		 
    		double absB; //absolute bearing 
    		//double dist; //Saves codesize
    		int i; 		 		    		
    		int index; //index of the match of the pm gun

    		  
                          
            
            
    	  //Note: the pm gun is now derived from WeekendObsession. It's located under the movement now to save some codesize on absB.
              
          //Movement: Stop and Go, if it fails, simple random movement

            if(prevEnergy > (prevEnergy = e.getEnergy()) ){
                if(deathCount > DEATHLIMIT){
                	//direction = (40000.0*(Math.random() - Math.random()));
                	direction = (Math.random()*100000-50000);
                	//setMaxVelocity(16.0*Math.random());
                	//direction = Math.random()*80000-60000;
                }
                setAhead(direction);
            }
            //setTurnRightRadians(Math.cos(absB = e.getBearingRadians()) - Math.signum(direction * ((dist = e.getDistance()) - DISTANCE))/PLUSANGLEMULTI);
            setTurnRightRadians((Math.cos(absB = e.getBearingRadians())));
            // Now with the pm gun of Simonton's WeekendObsession
            // Credits to nz.jdc.NeophytePattern for BFTIME-type squeezing ;)
            
            //Inserting the newest lateral velocity into the beginning of our log
            enemyLog = String.valueOf( (char)Math.round(e.getVelocity() * Math.sin(e.getHeadingRadians() - ( absB+=getHeadingRadians() )))).concat(enemyLog);

            //Reducing pattern depth until find a match. Store the index of the match.
            while((index = enemyLog.indexOf(enemyLog.substring(0, matchLenght--), (i = (int)((e.getDistance())/BULLETVEL)))) < 0);
            //Now matchlenth equals to BFTIME, because this will be the counter in the next loop
            //matchLenght = BFTIME;

            //Add the angular velocities of the first BFTIME lateral velocities to absolute bearing.  
            do{
                absB += Math.asin(((byte)enemyLog.charAt(index--))/e.getDistance());
            }while(--i > 0);

            //Turning gun to head the predicted absolute bearing
            setTurnGunRightRadians(Utils.normalRelativeAngle(absB-getGunHeadingRadians()));
            
            //Fire in the hall!
            //setFire(prevEnergy/FPFACTOR);
            setFire(FIREPOWER);
            //setFire(FIREPOWER);

            setTurnRadarLeft(getRadarTurnRemaining());
    }
    public void onHitWall(HitWallEvent e){
        direction =-direction;
    }

    public void onDeath(DeathEvent e){
        deathCount++;
    }
    /*public void onHitByBullet(HitByBulletEvent e){
    	prevEnergy += 3.0*e.getPower();
    }*/
}
