package shinh;

import robocode.*;

public class BulletTracker extends Condition {
	private Enemy target_;
	private Bullet bullet_;
	private double turn_;
	private double x_;
	private double y_;
	private boolean calcMove_ = false;
	private Move move_;

	public BulletTracker(Enemy target, Bullet bullet, Move move) {
		target_ = target;
		bullet_ = bullet;
		move_ = move;

		if (Entangled.me.getOthers() == 1) {
			calcMove_ = true;
			turn_ = target.distance / (20 - 3 * bullet.getPower()) +
				Entangled.me.getTime();
			x_ = target.x;
			y_ = target.y;
		}
	}

	private void removeEvent() {
		Entangled.me.removeCustomEvent(this);
	}

	public boolean test() {
		Entangled ent = Entangled.me;
		if (calcMove_ && turn_ < ent.getTime()) {
			calcMove_ = false;
			target_.vx = target_.x - x_;
			target_.vy = target_.y - y_;
		}

		if (target_.name == bullet_.getVictim()) {
			target_.predictor.evaluation += 20;
			target_.predictor.hitNum++;
			int others = ent.getOthers();
			if (others == 0) others = 1;
			double d = Util.calcBulletDamage(bullet_.getPower()) / others;
			move_.evaluation += d;
			move_.damages += d;

			removeEvent();
		}
		else if (!bullet_.isActive()) {
			if (Entangled.me.getOthers() > 0)
				target_.predictor.evaluation -= 20;
			removeEvent();
		}
		else if (bullet_.getVictim() != null) {
			target_.predictor.evaluation -= 20;
			removeEvent();
		}

		return false;
	}
}
