package m3thos.mini;
import robocode.*;
import java.awt.Color;

/**
 * Eva01 - a robot by Miguel Sousa Filipe
 *
 * Extremely Simple behavior. meant to be fast & simple.
 *
 * Version 0.5.5
 * - small bug fix
 * - change firepower calc
 * Version 0.5.3 (codesize: 1477)
 * - code restructure that reduced codesize
 * - "stuck in corners" bug fix v1
 * - fixes & tunes in target selection
 * Version 0.5.2	(codesize: 1489)
 * - attempt to make it a minibot
 * - rewrote some if's.
 * - and removed some not very important crap.
 * Version 0.5.1	(codesize: 1860)
 * - moved some randoms around, they were conflicting with the anti-wall
 * - bug fixing in anti-wall related code.
 * Version 0.5		(codesize: 2271)
 * - anti-wall implemented.
 * - target selection is now diferent, same strategy, diferent implementaion.
 * Version 0.4.3	(codesize: 1704)
 * - removal of unneeded code.
 * - general clean up.
 * - even more constant tweaking
 * Version 0.4.2:   (codesize: 2431)
 * - v0.4.1 had fireType selection badly corrected.
 * - another constant tweaking
 * Version 0.4.1:
 * - mutch enhanced firing code.
 * - Now only switches target if new target is considerably closer to us.
 * - Corrected some small bugs in code
 *
 * Geracao 2. Version 0.4
 * - acceptable firing algorithm, now with 2 types of firing.
 * - attack closer bots first.
 * - use random for unpredictability of movement.
 */
public class Eva01 extends AdvancedRobot
{
    static private final double HALF_PI = (Math.PI/2);
    static private final double DOUBLE_PI = (Math.PI*2);
    static private final int LINEAR = 0; // linear targeting, the most important one
    static private final int DIRECT = 1; // direct targeting, it's when linear is performing very bad.
    // eco targeting, used when both are bad performers, will shoot only half of the requests
    static private final int ECO = 2;
    static private final double SAFE = 38; 	// mimimal allowed distance to walls
    static private double _distWallBefore;		// distance from walls in the last run
    static private int _wallCount;		// counts successive runs of antiWall near the wall
	static private boolean _avoid = false;	// tells if we're avoid walls ATM
    static private boolean _avancar = true;  // ve if we are walking ahead or back
    static private double _dist = 300;       // distance used has reference in all movements
    private Enemy _target;

    /**
     * run: Eva01's default behavior isn't important.
     */
    public void run()
    {
        setColors(Color.green,Color.white,Color.white);
        _target = new Enemy();
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        setAdjustRadarForRobotTurn(true);
        setTurnRadarRightRadians( Double.POSITIVE_INFINITY );
		out.println("Eva00 v0.5.5!");
        while(true)
        {
	        antiWall();
	        setAhead(_dist);
	        execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e)
    {
        double distance = e.getDistance();

        /**
		 * If the test succeeds, then target is of no interest:
		 * more than one enemy,  enemy found is not current target and not 50 pixels closer than current target.
		 */
        if( getOthers() > 1 &&  (_target.distance + 50) < distance )
        {
            if(_target.name.equals(e.getName()))
            {
                _target.distance = distance;
				_target.lsTime = getTime();
            }
            else if( getTime() - _target.lsTime > 3)
				_target.distance += 50;
		   return;
        }
        if( !_target.name.equals(e.getName()) )
        {
            _target.reset();
            _target.name = e.getName();
            _target.avgSpeed = e.getVelocity();
        }
        else
            _target.updateTargetAvgSpeed( e.getVelocity());
        _target.lsTime = getTime();
        _target.energy = e.getEnergy();
        _target.distance = distance;
        _target.heading = e.getHeadingRadians();
        _target.bearing = e.getBearingRadians();
        
        aimAndFire();

        antiWall();
        if(!_avoid)
        {
            if(Math.random() < .08)
				reverseDirection();
            distance = _target.bearing;
        /* If the target is "too" far away, we will strive to get near him
         * if he's "close" we'll keep perpendicular to him.*/
            if(_target.distance > 300) // still experimenting with this value.
                distance +=(( _avancar && _target.bearing < 0)? -Math.PI/5:(( _avancar || _target.bearing < 0)? Math.PI/5: -Math.PI/5));
            setTurnPerpendicularTo(distance);
        }
    }

    /**
     * Strategy explanation: once it was, to be perpendicular to bullet, wich is allways better for dodging.
     * but since in melee batles reacting to bullets that are constatly ariving is a bad ideia
     * Because we loose time reajusting heading for nothing
     * Now we only reajust the heading in 50% of the cases.
     * Also, adding a reverseDirection in 13% of the cases helps messing up
     * others robots target predition.
     */
    public void onHitByBullet(HitByBulletEvent e)
    {
        if ( e.getName().equals(_target.name) )
            _target.incHits();
        if ( !_avoid && Math.random() < 0.13)
            reverseDirection();
    }

// this should not happen since we now have a lame anti-wall thingie going on..
// but.. better safe than sorry :-p
    public void onHitWall(HitWallEvent e)
    {
        _avoid = true;
		reverseDirection();
		_distWallBefore = distanceToWall();
    }

    public void onHitRobot(HitRobotEvent e)
    {
        String name = e.getName();
        double ang = e.getBearingRadians();
        setTurnGunTo( ang);

        if( !_target.name.equals(name))
        {
            _target.reset();
            _target.name = name;
        }
        _target.energy = e.getEnergy();
        _target.lsTime = getTime();
        _target.distance = 20; // we give a 20 pixelradius to find our target
        _target.bearing = ang;

        if( getGunHeat() == 0)
        {
            fire(3);
            _target.incShots();
        }
    }

/*
    public void onDeath(DeathEvent e)
    {
        out.println("fired "+_shotsFired+" shots");
        out.println("I Hit "+_shotsHit+" shots");
        out.println("I was hit "+_bulletHit+" times");
        out.println("linear targeting Hit Ratio: "+_target.getHitRatio(LINEAR));
        out.println("direct targeting Hit Ratio: "+_target.getHitRatio(DIRECT));
        out.println("Absolute target Hit Ratio: "+_shotsHit/_shotsFired);
    }

	public void onRobotDeath(RobotDeathEvent e)
    {
        if (_target.name.equals(e.getName()))
        {
          _target.distance += 250;
          out.println("target died: "+_target.name);
          out.println("linear targeting Hit Ratio: "+_target.getHitRatio(LINEAR));
          out.println("direct targeting Hit Ratio: "+_target.getHitRatio(DIRECT));
        }
    }
*/
    /***************************************************************************
     *               Auxiliary Functions/Methods                               *
     *   used by the main methods and event handlers                           *
     ***************************************************************************/

    public void aimAndFire()
    {
        int i;
        double firePower = _target.calcFirePower(this.getEnergy());
        double absoluteBearing = getHeadingRadians() + _target.bearing;
        double gunBearing = normalizeBearing(absoluteBearing - getGunHeadingRadians());
        double turretTurnTime = gunBearing / 20; //20 is the turret turn velocity
        double bulletSpeed = 20 - 3 * firePower;
        double bulletFlightTime = turretTurnTime + _target.distance/bulletSpeed;
        double correction, dAngle, tAngle, tx, ty, newDistance;
        
        _target.updateFireType();
        
        if( _target.avgSpeed != 0 && _target.fireType != DIRECT )
        {
            dAngle = normalizeBearing(_target.heading - absoluteBearing);
            dAngle += ((dAngle > 0)? -HALF_PI:HALF_PI);
            tx = _target.distance * Math.cos(dAngle);
            ty = _target.distance * Math.sin(dAngle) + bulletFlightTime * _target.distance;
            // repeat this to improve acuracy
            for(i=0; i<5; i++)
            {
                // --start--
                tAngle = Math.atan(ty/tx);
                newDistance = ty/Math.sin(tAngle);
                bulletFlightTime = turretTurnTime + newDistance / bulletSpeed;
                ty = _target.distance * Math.sin(dAngle) + bulletFlightTime * _target.avgSpeed;
                // --stop--
            }
            correction = dAngle - Math.atan(ty/tx);
            if( normalizeBearing(_target.heading - absoluteBearing) >= 0)
                correction *=  -1;
            gunBearing = normalizeBearing(gunBearing + correction);
        }
        
        turnGunRightRadians(gunBearing);        
        if( getGunHeat() == 0 && ( _target.fireType != ECO ||
                            (_target.fireType == ECO && Math.random() < .5)) )
        {
            fire(firePower);
            _target.incShots();
        }
    }

    /** doMovement
     * 
     * implements anti-wall and in melee stays away from the center
     *
     */
    private void antiWall() {
        double wall_dist;
        if ((wall_dist = distanceToWall()) < SAFE) {
            if (_wallCount++ > 50) {
                //out.println("Estou num canto.. vou tentar sair!");
                setTurnPerpendicularTo(getHeadingRadians());
                _wallCount = 0;
            }
            if (!_avoid && _distWallBefore > (_distWallBefore = wall_dist) ) {
                _avoid = true;
                reverseDirection();
            }
        } else {
            _wallCount = 0;
            _avoid = false;
//            if( getOthers() > 1 && wall_dist > _dist)
//                reverseDirection();
        }
    }


    private void reverseDirection()
    {
        _dist *= -1;
        _avancar = ((_avancar)? false : true);
    }

    // yes.. it gives the distance from nearest wall.
	private double distanceToWall()
	{
		return Math.min(Math.min(getBattleFieldWidth() - getX(), getX()), Math.min(getBattleFieldHeight() - getY(),getY()));
	}

    public void setTurnTo( double angle)
    {
        if (Math.abs(angle) > HALF_PI)
        {
            reverseDirection();
            angle += Math.PI;
        }
        setTurnRightRadians(normalizeBearing(angle));
    }
    
    public void setTurnPerpendicularTo( double angle)
    {
        angle += ((angle > 0) ? -HALF_PI : HALF_PI);
        setTurnRightRadians(angle);
    }
    
    public void setTurnGunTo( double angle)
    {
        angle += getHeadingRadians() - getGunHeadingRadians();
        setTurnGunRightRadians(normalizeBearing(angle));
    }
    
    //if a bearing is not within the -pi to pi range, alters it to provide the shortest angle
    public double normalizeBearing(double ang)
    {
        return (ang + (9 * Math.PI)) % (2 * Math.PI) - Math.PI;
    }
}
