package uccc;

import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.HitWallEvent;
import robocode.util.Utils;
import robocode.Rules;

import java.awt.*;
import java.lang.*;
import java.awt.Color;
import java.awt.Graphics2D;
 

public class RingDing extends AdvancedRobot {

	int timeout = 0;
	double ifx,ify,brx,bry;
	vec2 dir;
	double dir_mult=1;
	ScannedRobotEvent lastevent;
	double keepdist = 300;
	double bulletPower = 1;
	String str1,str2,str3 = "";
	int timeSinceScan =0;
	//a1 is where you want to go
	//a2 is where you are
	public double getShortAngle(double a1, double a2)
	{
	    double angle = (a1 - a2);

	    if(angle > Math.PI)
	        angle = 2*Math.PI - angle;
	    if(angle < -1*Math.PI) 
	    	angle = -1 * (2*Math.PI + angle);
	    if( a1<=Math.PI/2 && a2 > 3*Math.PI/2 ) {
	    	angle = Math.abs(angle);
	    }
	    if( a2<=Math.PI/2 && a1 > 3*Math.PI/2 ) {
	    	angle = Math.abs(angle)*-1;
	    }
	    return angle;
	}
	 public void onPaint(Graphics2D g) {
     	// Set the paint color to a red half transparent color
     	g.setColor(new Color(0xff, 0xff, 0xff, 0xff));
     	g.drawString(str1, 0, 40);
     	g.drawString(str2, 0, 20);
     	g.drawString(str3, 0, 0);
     	g.setColor(new Color(0xff, 0x00, 0x00, 0x80));
    	// Draw a line from our robot to the scanned robot
     	g.drawLine((int)(ifx+getX()), (int)(ify+getY()), (int)getX(), (int)getY());
		g.setColor(new Color(0xff, 0x80, 0x80, 0x80));
 		g.drawLine((int)(brx+getX()), (int)(bry+getY()), (int)getX(), (int)getY());
     	// Draw a filled square on top of the scanned robot that covers it
     	//g.fillRect(scannedX - 20, scannedY - 20, 40, 40);
 	}
	public void setDir(vec2 v, double mult) {
		dir = new vec2(v);
		dir_mult= mult;
	}
	public void run() {
		// Paint a transparent square on top of the last scanned robot

		// Set colors
		setBodyColor(Color.blue);
		setGunColor(Color.blue);
		setRadarColor(Color.black);
		setScanColor(Color.yellow);
		setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		setAdjustRadarForRobotTurn(true);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		// Loop forever
		while (true) {
			timeSinceScan++;
			if (timeSinceScan>10) {
				setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			}
			ScannedRobotEvent e = lastevent;
			if (e == null) {
				setTurnRadarRightRadians(1000);
				execute();
				continue;
			}
			double headTurn = e.getBearingRadians() + getHeadingRadians();
			vec2 bear = new vec2(headTurn+Math.PI/2,e.getDistance());
			//vec2 head = new vec2(getHeadingRadians(),60);
			brx = Math.sin(getHeadingRadians());
			bry = Math.cos(getHeadingRadians());
			//bear = vec2.getOrtho(bear);
			bear.normalize();
			ifx = bear.getY()*30;
			ify = bear.getX()*30;
			if (e.getDistance()>keepdist || e.getDistance()<keepdist) {
				vec2 t = new vec2(headTurn,e.getDistance()/keepdist - 1);
				t.mult(dir_mult);
				bear.add(t);	
			}
			headTurn = bear.getAngle();
			Double ht = headTurn;
			str1 = ht.toString();
			Double h = getHeadingRadians();
			str2 = h.toString();
			headTurn = getShortAngle(headTurn, getHeadingRadians());
			ht = headTurn;
			str3 = ht.toString();
			//headTurn = headTurn - getHeadingRadians();
			//if (Math.abs(headTurn)>(3.14159/2)) {
			//	bear.mult(-1);
			//	headTurn = bear.getAngle();
			//	headTurn = getHeadingRadians() - headTurn;
			//}
	
			
			if (Math.abs(headTurn)<3.14159/8) {
				setMaxVelocity(7);
				setAhead(1000*dir_mult);
			}
			else {
				setMaxVelocity(2);
				setAhead(1000*dir_mult);
			}
			setTurnRightRadians(headTurn);
			execute();
		}
	}
	public void onHitWall(HitWallEvent e) {
		dir_mult = dir_mult*-1;
	}
	public void adjustBulletPower(ScannedRobotEvent e) {
		if (e.getDistance()>100) 
			bulletPower=1;
		if (e.getDistance()<=100) {
			bulletPower = keepdist/e.getDistance()*3;
		}
	}
	/**
	 * onScannedRobot: Fire hard!
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		timeSinceScan = 0;
		adjustBulletPower(e);
		lastevent = e;
		double radarTurn =
        // Absolute bearing to target
        getHeadingRadians() + e.getBearingRadians()
        // Subtract current radar heading to get turn required
        - getRadarHeadingRadians();
		//double gunTurn = 0.05;
		double gunTurn;
		
		//if (e.getDistance()<50) {
		//	gunTurn = getShortAngle(getHeadingRadians() + e.getBearingRadians(),getGunHeadingRadians());
		//}
		//else {
			gunTurn = getShortAngle(targetRoutine(e),getGunHeadingRadians());
		//}
			
        // Subtract current radar heading to get turn required
		//vec2 v1 = new vec2(gunTurn, e.getDistance());
		//v1.add(new vec2(e.getHeadingRadians(),e.getVelocity()*e.getDistance()/100));
		//double gunTurn2 = v1.getAngle() - getGunHeadingRadians();
		

		//setTurnRight(headTurn);
		setTurnRadarRightRadians(2.0 *Utils.normalRelativeAngle(radarTurn));
		setTurnGunRightRadians(gunTurn);
		if (e.getDistance()<keepdist+100) {
			setFire(bulletPower);
		}
	}
	public double targetRoutine(ScannedRobotEvent e) {
		double bearing =
	        // Absolute bearing to target
	        getHeadingRadians() + e.getBearingRadians();
		vec2 bearingVec = new vec2(bearing, 1);
		bearing = getRadianClamp(bearing+Math.PI/2);
		vec2 basis = new vec2(bearing, 1);
		vec2 enemyHead = new vec2(e.getHeadingRadians(), e.getVelocity());
		vec2 proj = vec2.proj(enemyHead, basis);
		double bulletSpeed = Rules.getBulletSpeed(bulletPower);
		double t = bulletSpeed/e.getDistance();
		proj.mult(t);
		proj.add(bearingVec);
		return proj.getAngle();
	}
	public double getRadianClamp(double a) {
		if (a>Math.PI*2)
			a-=Math.PI*2;
		if (a<0)
			a+=Math.PI*2;
		return a;
	}
	/**
	 * onHitRobot:  If it's our fault, we'll stop turning and moving,
	 * so we need to turn again to keep spinning.
	 */
	public void onHitRobot(HitRobotEvent e) {
		//if (e.getBearing() > -10 && e.getBearing() < 10) {
		//	fire(3);
		//}
		if (e.isMyFault()) {
			//turnRight(10);
		}
	}
	public void onHitByBullet(HitByBulletEvent e) {
		if (lastevent.getDistance()>150) {
			dir_mult=dir_mult*-1;
		}
	}
}
class vec2 { 
	double x,y;
	public vec2(vec2 v)
	{
		x=v.getX();
		y=v.getY();
	}
	public vec2(double angle, double mag) {
		x = mag*Math.cos(angle);
		y = mag*Math.sin(angle);
	}
	public void mult(double a) {
		x = x*a;
		y= y*a;
	}
	public void add(vec2 v) {
		x += v.getX();
		y += v.getY();
	}
	public void sub(vec2 v) {
		x -= v.getX();
		y -= v.getY();
	}
	public double getX() {
		return x;
	}
	public double getY() {
		return y;
	}
	public void set(double angle, double mag) {
		x = mag*Math.cos(angle);
		y = mag*Math.sin(angle);
	}
	public double dot(vec2 v) {
		return x*v.getX() + y*v.getY();
	}
	public double getMag() {
		return Math.sqrt(x*x+y*y);
	}
	public double getMagSquared() {
		return x*x+y*y;
	}
	public double getAngle() {
		double a=0;
		if (x==0) {
			if (y>0) {
				return Math.PI/2;
			}	
			return 3*Math.PI/2;
		}
	
		if (y>0 && x>0) {
			a= Math.atan(y/x);
		}
		if (y>0 && x<0) {
			a = Math.PI - Math.atan(y/x*-1);	
		}
		if (y<0 && x<0) {
		 	a = Math.PI + Math.atan(y/x);	
		}
		if (y<0 && x>0) {
			a = 2 * Math.PI - Math.atan(y/x*-1);	
		}
		return a;
	}
	public void normalize() {
		double mag = getMag();
		x=x/mag;
		y=y/mag;	
	}
	public static vec2 getOrtho(vec2 v) {
		vec2 w = new vec2(v.getAngle()+1, 1);
		v.mult( v.dot(w) / (v.getMag() * v.getMag() ) );
		w.sub(v);
		return w;
	}
	public static vec2 proj(vec2 a, vec2 basis) {
		vec2 r = new vec2(basis);
		r.mult(a.dot(basis)/basis.getMagSquared());
		return r;
	}
}