package dsekercioglu.mega.wfGun.gun;

import dsekercioglu.mega.megaCore.KNNPredictor;
import dsekercioglu.mega.wfGun.GunUtils;
import java.util.ArrayList;

import java.io.*;
import java.util.zip.*;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;

public class MainGun extends AbstractPredictor {

    private final KNNPredictor PREDICTOR;
    public final int BINS;
    public final int K = 147;
    public final int SIZE_DIVIDER = 5;

    ArrayList<double[]> inputs = new ArrayList<>();
    ArrayList<Integer> outputs = new ArrayList<>();
    ArrayList<Boolean> isReal = new ArrayList<>();

    public MainGun(int bins) {
        BINS = bins;
        PREDICTOR = new KNNPredictor();
//        PREDICTOR.setup(new double[]{6.47, 3.64, 8.151, 6.32, 0.98, 9.02, 2.74, 6.68, 0.0017}, K, BINS, SQR_EUCLIDEAN, PREDICTOR.divisionK(K, SIZE_DIVIDER));
        PREDICTOR.setup(new double[]{6.47, 3.64, 8.151, 6.32, 0.98, 9.02, 2.74, 6.68, 0, 0, 0, 0.0017}, K, BINS, PREDICTOR.divisionK(K, SIZE_DIVIDER));
    }

    public double[] predict(double[] data) {
        return GunUtils.normalizeBinValues(PREDICTOR.predictBins(data));
    }

    public void wavePassed(double[] data, int bin, boolean real, double botWidth) {
        //if (real) {
        //    inputs.add(data);
        //    outputs.add(bin);
        PREDICTOR.addData(data, bin, 1);
        //}
    }

    public String getName() {
        return "Main Gun";
    }

    public Object readCompressedObject(String filename, AdvancedRobot r) {
        try {
            ZipInputStream zipin = new ZipInputStream(new FileInputStream(r.getDataFile(filename + ".zip")));
            zipin.getNextEntry();
            ObjectInputStream in = new ObjectInputStream(zipin);
            Object obj = in.readObject();
            in.close();
            return obj;
        } catch (FileNotFoundException e) {
            System.out.println("File not found!");
        } catch (IOException e) {
            System.out.println("I/O Exception");
        } catch (ClassNotFoundException e) {
            System.out.println("Class not found! :-(");
            e.printStackTrace();
        }
        return null;    //could not get the object
    }

    public void writeObject(Serializable obj, String filename, AdvancedRobot r) {
        try {
            System.out.println(r.getDataFile(filename + ".zip"));
            ZipOutputStream zipout = new ZipOutputStream(
                    new RobocodeFileOutputStream(r.getDataFile(filename + ".zip")));
            zipout.putNextEntry(new ZipEntry(filename));
            ObjectOutputStream out = new ObjectOutputStream(zipout);
            out.writeObject(obj);
            out.flush();
            zipout.closeEntry();
            out.close();
        } catch (IOException e) {
            System.out.println("Error writing Object:" + e);
        }
    }

    @Override
    public void onMatchEnded(AdvancedRobot r) {
        writeObject(inputs, "inputs", r);
        writeObject(outputs, "outputs", r);
    }
}
