package dsekercioglu.mega.wolfBreath;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import static robocode.util.Utils.normalRelativeAngle;

public class WolfBreath {

    AdvancedRobot a;

    Point2D.Double myLocation = new Point2D.Double();
    Point2D.Double enemyLocation;
    ArrayList<Double> absBearings;
    ArrayList<Point2D.Double> enemyLocations;
    double energy;

    FiringSolution bestFiringSolution = new FiringSolution(0, 0, 0, 0);

    int tick = 0;
    double bestMove;

    public WolfBreath(AdvancedRobot a) {
        this.a = a;
    }

    public void run() {
        absBearings = new ArrayList<>();
        enemyLocations = new ArrayList<>();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        tick = (int) a.getTime();
        myLocation.setLocation(a.getX(), a.getY());
        double distance = e.getDistance();
        double absBearing = a.getHeadingRadians() + e.getBearingRadians();
        enemyLocation = ShieldUtils.project(myLocation, absBearing, distance);
        absBearings.add(absBearing);
        double deltaEnergy = energy - (energy = e.getEnergy());
        if (deltaEnergy > 0.099 && deltaEnergy < 3.01) {
            Bullet b = new Bullet();
            b.bulletPower = deltaEnergy;
            b.velocity = 20 - 3 * deltaEnergy;
            b.source = (Point2D.Double) enemyLocations.get(0);
            bestFiringSolution = new FiringSolution(absBearing, 0, 0, Double.POSITIVE_INFINITY);
            bestMove = 0;
            for (int i = 0; i <= 50; i++) {
                double move = (i - 25) / 100.0;
                if (move == 0) {
                    continue;
                }
                Point2D.Double futurePos = ShieldUtils.project(myLocation, a.getHeadingRadians(), move);
                FiringSolution fs = getFireAngleAndPower(futurePos, myLocation, b, 1);
                if (fs.DEVIATION < bestFiringSolution.DEVIATION) {
                    try {
                        bestFiringSolution = (FiringSolution) fs.clone();
                    } catch (CloneNotSupportedException ex) {
                        Logger.getLogger(WolfBreath.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    bestMove = move;
                }
            }
            a.setTurnRightRadians(0);
            a.setAhead(bestMove);
        }
        if (tick == bestFiringSolution.FIRE_TICK) {
            a.setFire(bestFiringSolution.FIRE_POWER);
        }
        if (tick == bestFiringSolution.FIRE_TICK + 1) {
            a.setAhead(-bestMove);
        }
        if (tick != bestFiringSolution.FIRE_TICK && a.getDistanceRemaining() == 0) {
            bestFiringSolution = new FiringSolution(absBearing, 0, 0, Double.POSITIVE_INFINITY);
            a.setTurnRightRadians(normalRelativeAngle(absBearing + Math.PI / 2 - a.getHeadingRadians()));
        }
        a.setTurnGunRightRadians(normalRelativeAngle(bestFiringSolution.AIM_ANGLE - a.getGunHeadingRadians()));
        enemyLocations.add(0, (Point2D.Double) enemyLocation.clone());
        if (enemyLocations.size() > 2) {
            enemyLocations.remove(2);
        }

    }

    public void onBulletHit(BulletHitEvent e) {
        energy -= Rules.getBulletDamage(e.getBullet().getPower());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        energy += Rules.getBulletHitBonus(e.getPower());
    }

    public FiringSolution getFireAngleAndPower(Point2D.Double fireLocation, Point2D.Double shieldLocation, Bullet eb, int timeElapsed) {
        double enemyBulletAngle = enemyBulletAngle(shieldLocation);
        Point2D.Double enemyBulletFireLocation = ShieldUtils.project(eb.source, enemyBulletAngle, eb.velocity);
        for (int time = 0; time < 91; time++) {
            Point2D.Double bulletLoc = ShieldUtils.project(enemyBulletFireLocation, enemyBulletAngle, eb.velocity * (time + timeElapsed - 0.5));
            double bulletVelocityToCenter = fireLocation.distance(bulletLoc) / (time - 0.5);
            if (bulletVelocityToCenter <= 19.7 && bulletVelocityToCenter > 11) {
                if (bulletVelocityToCenter < eb.velocity) {
                    double bulletPower = (20 - eb.velocity) / 3;
                    return new FiringSolution(ShieldUtils.absoluteBearing(fireLocation, bulletLoc), bulletPower, tick + timeElapsed, bulletPower);
                }
                double bulletPower = (20 - bulletVelocityToCenter) / 3;
                return new FiringSolution(ShieldUtils.absoluteBearing(fireLocation, bulletLoc), bulletPower, tick + timeElapsed, bulletPower);
            }
        }
        return null;
    }

    public double enemyBulletAngle(Point2D.Double shieldLocation) {
        return ShieldUtils.absoluteBearing(enemyLocations.get(1), shieldLocation);
    }

    public class FiringSolution implements Cloneable {

        final double AIM_ANGLE;
        final double FIRE_POWER;
        final int FIRE_TICK;
        final double DEVIATION;

        public FiringSolution(double aimAngle, double firePower, int fireTick, double deviation) {
            AIM_ANGLE = aimAngle;
            FIRE_POWER = firePower;
            FIRE_TICK = fireTick;
            DEVIATION = deviation;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}
