/*
 * Copyright (c) 2004 Marcin Fuszara
 */  
package fushi.PvP1;
import robocode.*;

/* this class is a set of static methods helpful
 * in selecting fire power of bullets shot;
 */
public class FirePowerSelector
{
   static final double maxFirePower = 3;
   static final double minFirePower = 0.1;
   static final double minEnergy = 10;       //< energy below which the fire power is minimal
   static final double maxEnergy = 50;       //< energy above which the fire power is maximal
   static final double minDistance = 150;     //< distance to enemy below which the fire power is maximal
   static final double maxDistance = 700;    //< distance to enemy above which the fire power is minimal
   static final double criticalEnergy = 0.1; //< energy below which the robot will not shoot
   
   /* given current robot energy, distance to enemy and
    * targeting confidence proposes fire power for the bullet;
    * \param confidence may be greater than 1
    * \param randomize if true the resulting firePower is modified with Gaussian distribution
    * \return <=0 if it is better not to shoot at all; 
    *         otherwise: bullet power in range 0.1 to 3.0;
    */
   public static double determineFirePower( double energy, double distance, double confidence,
                                            boolean randomize )
   {
      // coefficients are in the range 0..1
      
      double energyCoefficient = ( energy - minEnergy ) / ( maxEnergy - minEnergy );
      energyCoefficient = Util.clipDouble( energyCoefficient, 0, 1 );
         
      double distanceCoefficient = 1 - ( ( distance - minDistance ) / ( maxDistance - minDistance ) );
      distanceCoefficient = Util.clipDouble( distanceCoefficient, 0, 1 );
         
      // select fire power         
      double firePower = energyCoefficient * distanceCoefficient * confidence
                        * ( maxFirePower - minFirePower ) + minFirePower;
                        
      if ( firePower < minFirePower )  // do not shoot is power calculated is to small
         return 0; 
         
      // clip it to boundaries
      firePower = Util.clipDouble( firePower, minFirePower, maxFirePower );
      
      if ( randomize ) { // randomize fire power with gaussian distribution
         double gauss = Util.randomGaussian();
         // choose randomly if it is to be added or subtracted
         double sign = Util.randomDouble( -1, 1 );
         if ( sign <= 0 )
            sign = -1;
         else
            sign = 1;
         // modify firePower
         firePower += sign * gauss;
       
         // clip it again
         firePower = Util.clipDouble( firePower, minFirePower, maxFirePower );
      }
      
      // if firing such a bullet would cause going under critical energy, decrease power
      if ( energy - firePower < criticalEnergy )
         firePower = Math.max( 0, energy - criticalEnergy );
      
      return firePower;
   }
}
      
      