package maribo.mini;

import java.awt.geom.Point2D;

import robocode.Rules;

abstract class Gun {
	public long[][] hits = new long[(MiniQuester.numEn/3)+1][MiniQuester.distSeg];
	public abstract double getFiringAngle(Enemy me, Enemy en, double bulletPower);
}

class CircularGun extends Gun {
	public double getFiringAngle(Enemy me, Enemy en, double bulletPower) {
		double heading = en.heading;
		double deltaHeading = en.deltaHeading;
		double deltaTime = 1;
		Point2D.Double predicted = new Point2D.Double(en.x, en.y);
		while((++deltaTime) * Rules.getBulletSpeed(bulletPower) < me.distance(predicted)){		
			predicted = MiniQuester.calcPos(predicted, en.velocity, heading);
			heading += deltaHeading;
			if(!MiniQuester.board.contains(predicted)){ break; }
		}
		return MiniQuester.calcAngle(predicted, me);
	}
}

class HeadOnGun extends Gun {
	public double getFiringAngle(Enemy me, Enemy en, double bulletPower) {
		return MiniQuester.calcAngle(en, me);
	}
}