/**
 * Copyright (c) 2009 Nat Pavasant; All right reserved.
 * Source code is released under the term of Nat Public Robot License 2.1
 */
package nat.base.actors;

import nat.base.BotBase;
import nat.utils.M;
import nat.utils.Point;

/**
 * Robot Movement Controller
 * 
 * @author Nat Pavasant
 */
public final class MovementActor extends ActorBase {
	
	public MovementActor(BotBase robot) {
		super(robot);
	}
	
	public void setSpeed(double velocity) {
		_robot.setMaxVelocity(velocity);
	}
	
	public void turn(double angle) {
		_robot.setTurnRightRadians(angle);
	}
	
	public void turnTo(double angle) {
		_robot.setTurnRightRadians(M.normalRelativeAngle(angle - _robot.getHeadingRadians()));
	}
	
	public void move(double distance) {
		_robot.setAhead(distance);
	}
	
	public void lockVelocity(double velocity) {
		setSpeed(velocity);
		move(Double.POSITIVE_INFINITY);
	}
	
	public void reverseDirection() {
		move(-_robot.getDistanceRemaining());
	}
	
	public void goTo(Point pt) {
		Point current = new Point(_robot.getX(), _robot.getY());
		move(current.angle(pt), current.distance(pt));
	}
	
	public void move(double angle, double distance) {
		angle = M.normalRelativeAngle(angle - _robot.getHeadingRadians());
		if (M.abs(angle) > M.HALF_PI) {
			distance = -distance;
			if (angle < 0)
				angle += M.PI;
			else
				angle -= M.PI;
		}
		turn(angle);
		move(distance);
	}
}
