/**
 * Copyright (c) 2009 Nat Pavasant; All right reserved.
 * Source code is released under the term of Nat Public Robot License 2.1
 */
package nat.base.actors;

import nat.base.BotBase;
import nat.utils.M;

/**
 * @author Nat Pavasant
 */
public final class RadarActor extends ActorBase {
	
	public RadarActor(BotBase robot) {
		super(robot);
	}
	
	public void turnRadar(double angle) {
		_robot.setTurnRadarRightRadians(angle);
	}
	
	public void turnRadarTo(double angle) {
		_robot.setTurnRadarRightRadians(M.normalRelativeAngle(angle - _robot.getRadarHeadingRadians()));
	}
	
	public void turnRadarTo(nat.utils.Point pt) {
		turnRadarTo((new nat.utils.Point(_robot.getX(), _robot.getY())).angle(pt));
	}
	
	public void spin(int direction) {
		turnRadar(Double.POSITIVE_INFINITY * direction);
	}
	
	public void reverseDirection() {
		turnRadar(_robot.getRadarTurnRemaining());
	}
}
