package nat.gun.meteorite;

import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.HashMap;

import robocode.RobotDeathEvent;
import robocode.RobotStatus;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import nat.base.*;
import nat.base.actors.GunActor;
import nat.gfx.GraphicsLayer;
import nat.gfx.RobocodeGraphics;

public final class Meteorite extends EventListener implements Gun {
	public RobotStatus status;
	public Time time;
	public static HashMap<String, Enemy> enemies;
	public Logger logger;
	public GraphicsLayer g;

	static {
		enemies = new HashMap<String, Enemy>();
	}
	
	public Meteorite(Logger logger, RobocodeGraphics g) {
		this.g = g.getLayer("Gun", KeyEvent.VK_G);
		this.logger = logger;
		for (Enemy enemy : enemies.values()) {
			enemy.newRound();
		}
	}

	@Override
	public void doGun(GunActor actor) {
		// update value
		Collection<Enemy> enemiesSet = enemies.values();
		for (Enemy enemy : enemiesSet) {
			enemy.calculateScanInfo(enemiesSet, status);
			enemy.update();
		}
	}

	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		Enemy  enemy = enemies.get(e.getName());
		if (enemy == null) {
			enemies.put(e.getName(), enemy = new Enemy(e.getName()));
		}
		enemy.calculateBasicScanInfo(status, e);
	}

	@Override
	public void onRobotDeath(RobotDeathEvent e) {
		Enemy  enemy = enemies.get(e.getName());
		if (enemy != null) {
			enemy.kill();
		} 
	}

	@Override
	public void onStatus(StatusEvent e, Time time) {
		this.time = time;
		status = e.getStatus();
	}
}
