package nat.gun.meteorite;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

import nat.utils.M;
import nat.utils.Point;
import nat.utils.Range;
import nat.wave.*;

public class PIFViewsSet {
	private WeakHashMap<Wave,double[][]> cachedAngle;
	private PIFView[] views;
	private double[] weight;
	private int viewsCount = 0;
	
	public PIFViewsSet(PIFView... views) {
		cachedAngle = new WeakHashMap<Wave, double[][]>();
		this.views = views;
		viewsCount = views.length;
		weight = new double[viewsCount];
		for (int i = 0; i < viewsCount; i++) {
			weight[i] = 0.5d;
		}
	}
	
	public void setWeight(double... v) {
		if (v.length != views.length)
			throw new IllegalArgumentException();
		System.arraycopy(v, 0, weight, 0, weight.length);
	}
	
	public final List<PIFLocation> getPredictedLocation(Wave associatedWave, ScanInfo lastScan, Trace trace, int size, Point fireLocation, double bulletVelocity) {
		List<PIFLocation> returnList = new ArrayList<PIFLocation>(size * viewsCount);
		
		double[][] firingAngle = new double[viewsCount][size];
		
		for (int i = 0; i < viewsCount; i++) {
			PIFView view = views[i];
			List<PIFLocation> predicts = view.getLocation(lastScan, trace, size, fireLocation, bulletVelocity);
			for (int j = 0; j < predicts.size(); j++) {
				predicts.get(j).weight *= weight[i];
			}
			returnList.addAll(predicts);
			double[] angle = new double[predicts.size()];
			int j = 0;
			for (PIFLocation predict : predicts) {
				angle[j++] = predict.angle;
			}
			firingAngle[i] = angle;
		}
		
		cachedAngle.put(associatedWave, firingAngle);
		return returnList;
	}
	
	public final void adjustWeight(Wave wave) {
		Range hitRange = wave.passedRange;
		double lowerAngle = wave.getAngle(hitRange.lower);
		double upperAngle = wave.getAngle(hitRange.upper);
		
		double[][] fireAngle = cachedAngle.get(wave);
		
		if (fireAngle == null) {
			// something is wrong;
			return;
		}
		
		for (int i = 0; i < viewsCount; i++) {
			double[] fireAngles = fireAngle[i];
			double weight = 0;
			for (double angle : fireAngles) {
				double w = 1 - (getAngleOffset(lowerAngle, angle, upperAngle) / M.PI);
				weight += M.sqr(w);
			}
			weight /= fireAngles.length;
			this.weight[i] = M.rollingAvg(this.weight[i], weight, 250d);
		}
	}
	
	private static final double getAngleOffset(double lowerAngle, double angle, double upperAngle) {
		if (lowerAngle <= angle && angle <= upperAngle) {
			return 0d;
		}
		return M.min(M.abs(angle - lowerAngle), M.abs(angle - upperAngle));
	}
}
