package ags.muse.physics;

import ags.util.points.*;

/**
 * Simple storage class, representing the basic location/speed of a hypothetical robot
 */
public class RobotSim {
    public RobotSim() {}
    public RobotSim(RobotSim source) {
        location = source.location;
        velocity = source.velocity;
        hitWallFlag = source.hitWallFlag;
    }
    
    public AbsolutePoint location;
    public RelativePoint velocity;
    public boolean hitWallFlag;
    
    @Override
    public boolean equals(Object ob) {
        if (!(ob instanceof RobotSim))
            return false;
        final RobotSim sim = (RobotSim)ob;
        if (//location.x != sim.location.x ||
                //location.y != sim.location.y ||
                (int)(location.x/3) != (int)(sim.location.x/3) ||
                (int)(location.y/3) != (int)(sim.location.y/3) ||
                (int)(Math.toDegrees(velocity.direction)/15) != (int)(Math.toDegrees(sim.velocity.direction)/15) ||
                velocity.magnitude != sim.velocity.magnitude)
            return false;
        return true;
    }
    
    @Override
    public int hashCode() {
        return (int)velocity.magnitude+(int)(location.x/3)+(int)(location.y/3)+(int)(Math.toDegrees(velocity.direction)/15);
    }
}
