package djc.util;

import java.awt.geom.*;     // for Point2D's
import java.util.*; 	    // for collection of waves

import robocode.*;
import robocode.util.*;

/**
 * EnemyWave class from the basic WaveSurfer bot
 *
 *   Includes some stuff from http://robowiki.net/cgi-bin/robowiki?GFTargetingBot
 *   but done in Hashtables to support Melee mode.
 */
public class EnemyWave
{
	/********************************************************************************
	 *                        Member Variables                                      *
	 *******************************************************************************/	
    public Point2D.Double fireLocation;
	public Point2D.Double fireTargetLocation;
    public long fireTime;
    public double bulletVelocity, directAngle, distanceTraveled, shotPower;
	public Hashtable directAngles = new Hashtable();
	public Hashtable lastDistances = new Hashtable();
	public Hashtable curVelocity = new Hashtable();
	public Hashtable prevVelocity = new Hashtable();
    public int direction;
	public boolean singleAngle;
	public String enemyName;
	
	public EnemyWave(boolean isSingleAngle) { 
		singleAngle = isSingleAngle;
	}

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, calculate the index into our stat array for that factor.
    public int getFactorIndex(Point2D.Double targetLocation, String enemyName) {
		double myDirectAngle = ((Double)directAngles.get(enemyName)).doubleValue();
        double offsetAngle = (MyUtils.absoluteBearing(this.fireLocation, targetLocation)
            - myDirectAngle);
        double factor = Utils.normalRelativeAngle(offsetAngle)
            / MyUtils.maxEscapeAngle(this.bulletVelocity) * this.direction;

        return (int)MyUtils.limit(0,(factor * ((DynaBotConstants.GUESSFACTORBINS - 1) / 2)) + ((DynaBotConstants.GUESSFACTORBINS - 1) / 2),  DynaBotConstants.GUESSFACTORBINS - 1);
    }

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, calculate the index into our stat array for that factor.
    public int getFactorIndex(Point2D.Double targetLocation) {
		double myDirectAngle = directAngle;
        double offsetAngle = (MyUtils.absoluteBearing(this.fireLocation, targetLocation)
            - myDirectAngle);
        double factor = Utils.normalRelativeAngle(offsetAngle)
            / MyUtils.maxEscapeAngle(this.bulletVelocity) * this.direction;

        return (int)MyUtils.limit(0,(factor * ((DynaBotConstants.GUESSFACTORBINS - 1) / 2)) + ((DynaBotConstants.GUESSFACTORBINS - 1) / 2),  DynaBotConstants.GUESSFACTORBINS - 1);
    }


}