package homerbots;

import robocode.*;
import java.util.*;
import java.text.*;

/**
 *  h1 - Attempts to maintain an optimal distance from enemies
 * 
 * 
 */
public class h1 extends Robot {

	// Global enemy data store.  
	// 
	// Name is key, Vector of doubles is value 
	// (Bearing, Distance, Heading, Velocity, X-Position, Y-Position)
	// 
	public Map<String,Vector> enemies = new HashMap<String, Vector>();

	// Number of position points to consider around each enemy:
	Double rpoints = 100.0;

	// Distance to maintain from enemy:
	Double rdist = 250.0;

	// List of dead robots:
	public Vector deadbots = new Vector();

	// Direction to spin gun, alternates.
	int dir = 1;
	
	public void run() {
		while (true) {
			if( dir == 1 ){
				turnGunRight(360); 

			}else{
				turnGunLeft(360);
			}		
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		Double pwr = 3.0;
		if(getEnergy() < 15){
			pwr = (getEnergy() / 15 ) * 3;
		}
		fire(pwr);				// Shoot first, ask questions later
		recordEnemy(e); 		// Record this enemy in the global data store
		if(dir == 1){ dir = -1; }
		else{ dir = 1; }	
			
		// Clear out any dead robots from the enemy list:
		Iterator bi = deadbots.iterator();
		while(bi.hasNext()){
			enemies.remove((String)bi.next());
		}	

		
		// Generate a list of positions surrounding each enemy
		Vector positions = new Vector();	// List of potential positions (x,y,weight)
		for (Map.Entry<String,Vector> enemy : enemies.entrySet()){
			
			Vector edata = (Vector)enemy.getValue();	

			for (Double rang = 0.0; rang < 360; rang += (360/rpoints)){
				Double[] np = brgdst_to_xy(
						(Double)edata.elementAt(4),
						(Double)edata.elementAt(5),
						rang, rdist);
				Double msize = getWidth();
				if(getHeight() > msize){ msize = getHeight(); }
				if((np[0] < getBattleFieldWidth()-msize) && (np[0] > msize)	&& (np[1] > msize) && (np[1] < getBattleFieldHeight() - msize)){
					Vector pos = new Vector();
					pos.addElement(np[0]);
					pos.addElement(np[1]);
					pos.addElement(100.00);

					positions.addElement(pos);

					//out.println(np[0] + "," + np[1] + ",100");
				}
			}	// end position list

			   
			/*        out.println(
					  enemy.getKey() + ":" +	"xyp(" + edata.elementAt(4) + "," + edata.elementAt(5) + ")" +
				   	"brg(" + edata.elementAt(0) + ") " +  	"dst(" + edata.elementAt(1) + ") " +
				   	"hdg(" + edata.elementAt(2) + ") " +  	"vel(" + edata.elementAt(3) + ") " +
					"mep(" + getX() + "," + getY() + ")"	);
			*/		
			 
			
		} // end building position list
				

		// Discount positions for one reason or another
		Iterator pi = positions.iterator();
		while(pi.hasNext()){
			Vector cpos = (Vector)pi.next();
		
			Double pval = (Double)cpos.elementAt(2);	// Position weight

			// 1. Discount based on distance from me.  The further away,
			// the less desirable

			// Raw distance:
			Double d1 = distance( getX(), getY(),
					(Double)cpos.elementAt(0),
					(Double)cpos.elementAt(1));
			
			// As percent of battlefield size:
			d1 = d1/(Math.hypot(getBattleFieldWidth(),getBattleFieldHeight()));
			
			// Convert to a 0-30 point discount:
			d1 = d1 * 30.0;		

			pval -= d1;	
			// end 1	

			
			// 2 Discount the position based on the abs val of it's
			// bearing relative to my current heading. (Prefer points
			// which I'm already pointing at)
			Double a1 = angle(getX(), getY(), 
					(Double)cpos.elementAt(0),
					(Double)cpos.elementAt(1));

			Double ad1 = Math.abs(a1 - getHeading());
			if(ad1 > 180){ ad1 = 360 - ad1; }

			// Express the angle difference as a percent of 180 (the max angle difference)
			ad1 = ad1 / 180.0;

			// Translate this into a 10 point discount
			pval -= ad1 * 10;
			

			
			// 3 If I'm closer than a threshold distance to a point (read:
			// already there), then automatic 10 points off.  We need to 
			// keep moving.
			d1 = distance( getX(), getY(),
					(Double)cpos.elementAt(0),
					(Double)cpos.elementAt(1));
			if(d1 < 5){
				pval -= 10.0;
				//out.println("Num 3 Discount: 10pts");
			}


			
			// 4. Check distance from each enemy to this point.  Discount 
			// if closer than rdist from any enemy.
			for (Map.Entry<String,Vector> enemy : enemies.entrySet()){
				
				Vector edata = (Vector)enemy.getValue();	
				
				Double edist = distance(
					(Double)cpos.elementAt(0),
					(Double)cpos.elementAt(1),
					(Double)edata.elementAt(4),
					(Double)edata.elementAt(5)	
						);

				if( edist < rdist ){
					// Convert to a 10 point discount
					pval -= (edist / rdist) * 10;
					//out.println("Num 4 Discount: " + ((edist / rdist) * 10) + "pts");
				}
			} // end 4
			
			

			// 5. Discount the position based on it's bearing relative to
			// each enemy's heading, modified for distance from and
			// velocity of the enemy.  (Disdain points that an enemy is
			// going towards)
			for (Map.Entry<String,Vector> enemy : enemies.entrySet()){
				
				Vector edata = (Vector)enemy.getValue();	

				Double pangle = angle(
					(Double)cpos.elementAt(0),
					(Double)cpos.elementAt(1),
					(Double)edata.elementAt(4),
					(Double)edata.elementAt(5)	
				);
			
				Double eangle = (Double)edata.elementAt(2);
				if((Double)edata.elementAt(3) < 0){	// Negative velocity means reverse the direction
					if(eangle > 180){ eangle -= 180; }
					else{ eangle += 180; }
				}	
				
				Double adiff = Math.abs(pangle - eangle);
				if(adiff > 180){ adiff = 360 - adiff; }
				//out.println("adiff: " + adiff + " degs");	
				// Express the angle difference as a percent of 180 (the max angle difference)
				adiff = adiff / 180.0;

				// Invert it, since more difference is better:
				adiff = 1.0 - adiff;

				// Adjust discount for velocity (I think 8 is max
				// velocity):
				adiff = adiff * ( Math.abs((Double)edata.elementAt(3)) / 8);
			
				// Adjust discount for distance from enemy:
				Double adist = distance(
					(Double)cpos.elementAt(0),
					(Double)cpos.elementAt(1),
					(Double)edata.elementAt(4),
					(Double)edata.elementAt(5)	
					);	
				adiff = adiff * (1 - (adist/Math.hypot(getBattleFieldWidth(),getBattleFieldHeight())));
				
				// Discount the position up to 10 points:
				pval -= adiff * 10;
				//out.println("Num 5 Discount: " + (adiff * 10) + "pts");
			}	
			
			// Add weight back to position vector:
			cpos.setElementAt(pval, 2);
			//out.println(cpos.elementAt(2) + " - " + cpos.elementAt(0) + "," + cpos.elementAt(1));
		}


		// Pick the most desirable location and go there:

		Double max = 0.0;
		Double mx = 0.0;		
		Double my = 0.0;
		
		Iterator it = positions.iterator();
		while(it.hasNext()){
			Vector p = (Vector)it.next();
			if((Double)p.elementAt(2) > max){ 
				max = (Double)p.elementAt(2); 
				mx = (Double)p.elementAt(0);
			    my = (Double)p.elementAt(1);	
			}
		}
		DecimalFormat mF = new DecimalFormat("###.##");
		out.println("X: " + mF.format(mx) + ", Y: " + mF.format(my) + " Score: " + mF.format(max) + " (" + positions.size() + " total)");

		Double newhdg = angle(getX(), getY(), mx, my);
		//out.println("Cur Heading: " + getHeading());
		//out.println("New Heading: " + newhdg);
		newhdg = newhdg - getHeading();

		if(newhdg < 0){ 
			if( Math.abs(newhdg) > 180){ turnRight( 360 + newhdg); }
			else{ turnLeft( Math.abs(newhdg) ); } 
		}
		else{ 
			if( newhdg > 180 ){ turnLeft( 360 - newhdg ); }
			else{ turnRight( newhdg ); } 
		}
		//out.println("Ahead " + distance(getX(), getY(), mx, my));
		ahead( distance(getX(), getY(), mx, my));
	}
	
	
   public void onHitRobot(HitRobotEvent event) {

	   // Move away
	  	if (event.getBearing() > -90 && event.getBearing() <= 90)
	      	back(50);
  		else
       		ahead(50);

   }

	public void onRobotDeath(RobotDeathEvent e){
		// Mark this enemy to be removed from the data store:
		deadbots.addElement(e.getName());
	}
	
	public void recordEnemy(ScannedRobotEvent e){
		Vector ed = new Vector();

		ed.addElement(e.getBearing());		// Bearing
		ed.addElement(e.getDistance());		// Distance
		ed.addElement(e.getHeading());		// Heading
		ed.addElement(e.getVelocity()); 	// Velocity

		// Calculate x,y position
		
		Double dbl_eang = getHeading() + e.getBearing();
		if(dbl_eang > 360){ dbl_eang = dbl_eang - 360; }
		if(dbl_eang < 0){ dbl_eang = dbl_eang + 360; }
		// dbl_eang should now have the absolute angle of the 
		// enemy with our own x,y position as origin

		Double[] epos = brgdst_to_xy(getX(),getY(),dbl_eang,e.getDistance());	
		
		ed.addElement(epos[0]);
		ed.addElement(epos[1]);

		// Record finished enemy data record
		enemies.put(e.getName(), ed);

	} // end recordEnemy()


	/*
	 * Compute the distance between two points
	 */
	
	public Double distance(Double x1, Double y1, Double x2, Double y2){
		Double x = Math.abs(x2-x1);
		Double y = Math.abs(y2-y1);

		return Math.hypot(x,y);
	}	

	/* 
	 *  Compute the angle of one x,y position relative to another
	 *  
	 */
	public Double angle(Double x1, Double y1, Double x2, Double y2){
		Double rangle = 0.0;
		
		if( (x2 > x1) && (y2 > y1) ){
			rangle = Math.toDegrees(Math.acos( (y2-y1) / distance(x1,y1,x2,y2) ));
		}else if( (x2 > x1) && (y2 < y1) ){
			rangle = Math.toDegrees(Math.acos( (x2-x1) / distance(x1,y1,x2,y2) )) + 90.0;
		//	out.println( (rangle-90.0) + " + 90" );
		}else if( (x2 < x1) && (y2 < y1) ){
			rangle = Math.toDegrees(Math.acos( (y1-y2) / distance(x1,y1,x2,y2) )) + 180.0;
		//	out.println( (rangle-180.0) + " + 180" );
		}else{
			rangle = Math.toDegrees(Math.acos( (x1-x2) / distance(x1,y1,x2,y2) )) + 270.0;
		//	out.println( (rangle-270.0) + " + 270" );
		}	

		return rangle;
	}

	/*
	 *	Convert a bearing and distance reading from a given reference
	 *	point into an x,y position.  Args are the reference x and y, the 
	 *	absolute angle toward the target, and the distance to the
	 *	target.  Returns the target x,y as a 2-item double array
	 */
	public Double[] brgdst_to_xy(Double refx, Double refy, Double rangle, Double rdist){
		Double nx = 0.0;
		Double ny = 0.0;
		
		if((0 <= rangle) && (rangle < 90)){
			nx = refx + (Math.sin(Math.toRadians(rangle)) * rdist);
			ny = refy + (Math.cos(Math.toRadians(rangle)) * rdist);
		}else if((90 <= rangle) && (rangle < 180)){
			nx = refx + (Math.cos(Math.toRadians(rangle - 90)) * rdist);
			ny = refy + (Math.sin(Math.toRadians(rangle - 90)) * rdist * -1.0);
		}else if((180 <= rangle) && (rangle < 270)){
			nx = refx + (Math.sin(Math.toRadians(rangle - 180)) * rdist * -1.0);
			ny = refy + (Math.cos(Math.toRadians(rangle - 180)) * rdist * -1.0);
		}else{
			nx = refx + (Math.cos(Math.toRadians(rangle - 270)) * rdist * -1.0);
			ny = refy + (Math.sin(Math.toRadians(rangle - 270)) * rdist);
		}

		Double[] rpt = new Double[2];
		rpt[0] = nx;
		rpt[1] = ny;

		return rpt;

	} // end brgdst_to_xy	

}												

