package cyragia;
import robocode.*;
import java.lang.Math;

public class EnemyBot
{
	//private vars
	private double bearing;
	private double distance;
	private double energy;
	private double heading;
	private double velocity;
	private String name;
	private double x;
	private double y;
	
	//constructor
	EnemyBot(){
		this.reset();
	}
	
	//basic methods
	public boolean none(){
		return name.equals("");
	}
	public void update(ScannedRobotEvent e){
		this.bearing = e.getBearing();
		this.distance = e.getDistance();
		this.energy = e.getEnergy();
		this.heading = e.getHeading();
		this.velocity = e.getVelocity();
		this.name = e.getName();
	}
	public void update(ScannedRobotEvent e, Robot robot){
		this.bearing = e.getBearing();
		this.distance = e.getDistance();
		this.energy = e.getEnergy();
		this.heading = e.getHeading();
		this.velocity = e.getVelocity();
		this.name = e.getName();
		
		double absBearingDeg = (robot.getHeading() + e.getBearing());
		if (absBearingDeg < 0) absBearingDeg += 360;
		
		this.x = robot.getX() + Math.sin(Math.toRadians(absBearingDeg)) * e.getDistance();
		this.y = robot.getY() + Math.cos(Math.toRadians(absBearingDeg)) * e.getDistance();
	}
	public void reset(){
		this.bearing = 0.0;
		this.distance = 0.0;
		this.energy = 0.0;
		this.heading = 0.0;
		this.velocity = 0.0;
		this.x = 0.0;
		this.y = 0.0;
		this.name = "";
	}
	
	//getters
	public double getBearing(){
		return this.bearing;
	}
	public double getBearingRadians(){
		return this.bearing * (Math.PI/180);
	}
	public double getDistance(){
		return this.distance;
	}
	public double getEnergy(){
		return this.energy;
	}
	public double getHeading(){
		return this.heading;
	}
	public double getHeadingRadians(){
		return this.heading * (Math.PI/180);
	}
	public double getVelocity(){
		return this.velocity;
	}
	public String getName(){
		return this.name;
	}
	public double getX(){
		return this.x;
	}
	public double getY(){
		return this.y;
	}
	public double getFutureX(long when){
		return x + Math.sin(Math.toRadians(getHeading())) * getVelocity() * when;
	}
	public double getFutureY(long when){
		return y + Math.cos(Math.toRadians(getHeading())) * getVelocity() * when;
	}
}
