/*
 * Decompiled with CFR 0.152.
 */
package divineomega;

import divineomega.DivineBot;
import java.util.HashMap;

public abstract class MovementMode {
    static final String modeMirrorEratic = "mirror_eratic";
    static final String modeMirrorPerfect = "mirror_perfect";
    static final String modeWaveSurfingAdaptive = "wave_surfing_adaptive";
    static final String modeWaveSurfingContinual = "wave_surfing_continual";
    static final String modeWaveSurfing = "wave_surfing";
    static final String modeRandom = "random";
    static final String modeRamming = "ramming";
    static final String modeRammingHeadon = "ramming_headon";
    static final String modeDangerZones = "danger_zones";
    private static HashMap<String, String> modeData = new HashMap();
    private static HashMap<String, Integer> rounds = new HashMap();
    private static HashMap<String, Integer> wins = new HashMap();

    public static HashMap<String, String> getModeData() {
        return modeData;
    }

    public static HashMap<String, Integer> getRounds() {
        return rounds;
    }

    public static HashMap<String, Integer> getWins() {
        return wins;
    }

    public static void setModeData(HashMap<String, String> tacticData) {
        modeData = tacticData;
    }

    public static void setRounds(HashMap<String, Integer> rounds) {
        MovementMode.rounds = rounds;
    }

    public static void setWins(HashMap<String, Integer> wins) {
        MovementMode.wins = wins;
    }

    static void incrementRounds(String enemyName) {
        if (DivineBot.movementOverride.enabled) {
            return;
        }
        if (!DivineBot.getMovementToPlayback().isEmpty()) {
            return;
        }
        if (DivineBot.bulletShieldActive) {
            return;
        }
        int numRounds = rounds.get(enemyName);
        int numWins = wins.get(enemyName);
        if (numRounds > 9999 || numWins > 9999) {
            rounds.put(enemyName, numRounds / 100);
            wins.put(enemyName, numWins / 100);
        }
        rounds.put(enemyName, rounds.get(enemyName) + 1);
    }

    static void incrementWins(String enemyName) {
        if (DivineBot.movementOverride.enabled) {
            return;
        }
        if (!DivineBot.getMovementToPlayback().isEmpty()) {
            return;
        }
        if (DivineBot.bulletShieldActive) {
            return;
        }
        wins.put(enemyName, wins.get(enemyName) + 1);
    }

    static String get(String enemyName) {
        return modeData.get(enemyName);
    }

    static String set(String enemyName, String movementMode) {
        return modeData.put(enemyName, movementMode);
    }

    static void initialise(String enemyName) {
        if (modeData.get(enemyName) == null) {
            MovementMode.change(enemyName, modeWaveSurfingAdaptive);
        }
        if (rounds.get(enemyName) == null) {
            rounds.put(enemyName, 0);
        }
        if (wins.get(enemyName) == null) {
            wins.put(enemyName, 0);
        }
    }

    static void evaluate(String enemyName) {
        if (DivineBot.bulletShieldActive) {
            return;
        }
        if (rounds.get(enemyName) < DivineBot.numRounds) {
            return;
        }
        if (!MovementMode.isTacticEffective(enemyName)) {
            DivineBot.output(String.valueOf(enemyName) + " - Ineffective movement mode: " + modeData.get(enemyName) + " - " + wins.get(enemyName) + " of " + rounds.get(enemyName) + " have been won");
            if (modeData.get(enemyName).equals(modeWaveSurfingAdaptive)) {
                MovementMode.change(enemyName, modeWaveSurfingContinual);
            } else if (modeData.get(enemyName).equals(modeWaveSurfingContinual)) {
                MovementMode.change(enemyName, modeWaveSurfing);
            } else if (modeData.get(enemyName).equals(modeWaveSurfing)) {
                MovementMode.change(enemyName, modeMirrorEratic);
            } else if (modeData.get(enemyName).equals(modeMirrorEratic)) {
                MovementMode.change(enemyName, modeMirrorPerfect);
            } else if (modeData.get(enemyName).equals(modeMirrorPerfect)) {
                MovementMode.change(enemyName, modeRandom);
            } else if (modeData.get(enemyName).equals(modeRandom)) {
                MovementMode.change(enemyName, modeRamming);
            } else if (modeData.get(enemyName).equals(modeRamming)) {
                MovementMode.change(enemyName, modeRammingHeadon);
            } else if (modeData.get(enemyName).equals(modeRammingHeadon)) {
                MovementMode.change(enemyName, modeDangerZones);
            } else if (modeData.get(enemyName).equals(modeDangerZones)) {
                MovementMode.change(enemyName, modeWaveSurfingAdaptive);
            } else {
                MovementMode.change(enemyName, modeWaveSurfingAdaptive);
            }
        }
    }

    public static boolean isTacticEffective(String enemyName) {
        if (wins.get(enemyName) == null || rounds.get(enemyName) == null) {
            return false;
        }
        return !((double)wins.get(enemyName).intValue() < (double)rounds.get(enemyName).intValue() * 0.6);
    }

    public static boolean isTacticSuperEffective(String enemyName) {
        if (wins.get(enemyName) == null || rounds.get(enemyName) == null) {
            return false;
        }
        return !((double)wins.get(enemyName).intValue() < (double)rounds.get(enemyName).intValue() * 1.0);
    }

    public static void change(String enemyName, String modeName) {
        DivineBot.output(String.valueOf(enemyName) + " - Changing movement mode to: " + modeName);
        modeData.put(enemyName, modeName);
        wins.put(enemyName, 0);
        rounds.put(enemyName, 0);
    }
}

