/*
 * Decompiled with CFR 0.152.
 */
package jje;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import jje.Coordinate;
import jje.GravPoint;
import jje.Target;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class BagPuss
extends AdvancedRobot {
    private boolean noTarget = true;
    private boolean circling = false;
    private boolean reverseCircle = false;
    private boolean targetDead = false;
    private double myPreviousBearing;
    private double distance = 0.0;
    private double bearingFromGun;
    private double bearingFromMe;
    private double predictedBearingFromGun;
    private double predictedBearingFromMe;
    private int sweepDir = 1;
    private boolean lockedOn = false;
    private final int MAX_SCAN_FAIL_COUNT = 2;
    private final int RADAR_TURN_ANGLE = 40;
    private final int AVOIDANCE = 50;
    private int wiggleCount;
    private int wiggle;
    private int unsuccessfulScanCounter = 0;
    int avoidance = 0;
    private boolean isLocked = false;
    private boolean sweepScan;
    private boolean firstScan;
    private final int SWEEP_SCAN_COUNTDOWN = 10;
    private int sweepScanCountdown = 10;
    private int dontMoveFor = 0;
    int midpointcount = 10000;
    double midpointstrength;
    Coordinate midpoint;
    private boolean jiggleAhead;
    private Target target = null;
    private int bulletsFired;
    private int lastTenBulletsFired;
    private int bulletsMissed;
    private int bulletsHit;
    private int lastOutOfTenBulletsHit;
    private int tenBulletCounter;
    private int totalFirePower;
    private int totalTurns;
    private Hashtable targets = new Hashtable();
    private GravPoint[] gravpoints;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.red, Color.green, Color.blue);
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        double tenPercentX = this.getBattleFieldWidth() / 10.0;
        double tenPercentY = this.getBattleFieldHeight() / 10.0;
        GravPoint topLeft = new GravPoint(tenPercentX, this.getBattleFieldHeight() - tenPercentY, 2.0);
        GravPoint topRight = new GravPoint(this.getBattleFieldWidth() - tenPercentX, this.getBattleFieldHeight() - tenPercentY, 2.0);
        GravPoint bottomLeft = new GravPoint(tenPercentX, tenPercentY, 2.0);
        GravPoint bottomRight = new GravPoint(this.getBattleFieldWidth() - tenPercentX, tenPercentY, 2.0);
        this.gravpoints = new GravPoint[4];
        this.gravpoints[0] = topLeft;
        this.gravpoints[1] = topRight;
        this.gravpoints[2] = bottomLeft;
        this.gravpoints[3] = bottomRight;
        this.bulletsFired = 0;
        this.bulletsMissed = 0;
        this.bulletsHit = 0;
        this.totalFirePower = 0;
        this.totalTurns = 0;
        this.jiggleAhead = true;
        this.sweepScan = true;
        this.firstScan = true;
        this.setTurnRadarRight(360.0);
        this.execute();
        while (true) {
            this.myPreviousBearing = this.getHeading();
            boolean fired = false;
            if (!this.sweepScan) {
                this.setScan();
            }
            if (!this.firstScan) {
                fired = this.setGun();
                this.antiGravMove();
            }
            if (!fired) {
                this.execute();
            }
            ++this.totalTurns;
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        if (this.sweepScan) {
            if (this.targets.containsKey(event.getName())) {
                Target t = (Target)this.targets.get(event.getName());
                this.updateTarget(t, event);
                t.power = -1000.0;
            } else {
                Target t = new Target();
                this.updateTarget(t, event);
                this.targets.put(event.getName(), t);
            }
            return;
        }
        if (this.isLocked && this.target != null && event.getName() != this.target.getName()) {
            return;
        }
        if (--this.unsuccessfulScanCounter < 0) {
            this.unsuccessfulScanCounter = 0;
        }
        this.isLocked = true;
        this.noTarget = false;
        this.updateTarget(this.target, event);
    }

    boolean setGun() {
        if (this.target == null) {
            return false;
        }
        double absoluteBearing = this.getHeading() + this.target.getBearing();
        this.bearingFromGun = BagPuss.normalRelativeAngle(absoluteBearing - this.getGunHeading());
        double firePower = this.decideFirePower();
        long time = this.getTime() + (long)((int)(this.target.getDistance() / (20.0 - 3.0 * firePower)));
        Coordinate me = new Coordinate(this.getX(), this.getY());
        Coordinate them = new Coordinate(this.target.getEstimatedPosition(time));
        if (!them.linearIntercept) {
            int i = 0;
            while (i < 15) {
                long nextTime = (int)(me.distanceFrom(them) / (20.0 - 3.0 * firePower));
                time = this.getTime() + nextTime;
                them = new Coordinate(this.target.getEstimatedPosition(time));
                ++i;
            }
        } else {
            double impactTime = this.getImpactTime(10.0, 20.0, 0.01, this.target, firePower);
            Coordinate impactPoint = this.target.getEstimatedPosition(impactTime);
        }
        this.bearingFromMe = me.headingTo(this.target.getPosition());
        this.predictedBearingFromMe = me.headingTo(them);
        this.predictedBearingFromGun = BagPuss.normalRelativeAngle(this.predictedBearingFromMe) - this.getGunHeading();
        double nra = BagPuss.normalRelativeAngle(this.predictedBearingFromGun);
        this.setTurnGunRight(nra);
        double angleThreshold = Math.toDegrees(Math.atan(20.0 / this.distance));
        if (them.x > 0.0 && them.x < this.getBattleFieldWidth() && them.y > 0.0 && them.y < this.getBattleFieldHeight() && nra <= angleThreshold) {
            return this.doFire(firePower);
        }
        return false;
    }

    private double f(double time, Target target, double bulletPower) {
        double vb = 20.0 - 3.0 * bulletPower;
        Coordinate targetPosition = target.getEstimatedPosition(time);
        double dX = targetPosition.x - this.getX();
        double dY = targetPosition.y - this.getY();
        return Math.sqrt(dX * dX + dY * dY) - vb * time;
    }

    private double getImpactTime(double t0, double t1, double accuracy, Target target, double bulletPower) {
        double X = t1;
        double lastX = t0;
        int iterationCount = 0;
        double lastfX = this.f(lastX, target, bulletPower);
        while (Math.abs(X - lastX) >= accuracy && iterationCount < 15) {
            ++iterationCount;
            double fX = this.f(X, target, bulletPower);
            if (fX - lastfX == 0.0) break;
            double nextX = X - fX * (X - lastX) / (fX - lastfX);
            lastX = X;
            X = nextX;
            lastfX = fX;
        }
        return X;
    }

    void setMove() {
        if (this.dontMoveFor != 0) {
            --this.dontMoveFor;
            return;
        }
        double move = 0.0;
        Coordinate me = new Coordinate(this.getX(), this.getY());
        if (this.avoidance == 50) {
            move = -100.0;
            if (!this.wouldHitWall(me, this.getHeading(), move, this.getHeading() - this.myPreviousBearing)) {
                this.setTurnLeft(10.0);
                this.setAhead(move);
                --this.avoidance;
                return;
            }
            this.avoidance = 0;
        }
        if (this.circling && this.target.getDistance() > 250.0) {
            this.circling = false;
        }
        double keepDistance = 300.0;
        if (this.getEnergy() < 20.0) {
            keepDistance = 400.0;
        }
        if (this.circling || this.target.getDistance() < keepDistance) {
            if (!this.circling) {
                double turn;
                this.circling = true;
                if (this.target.getBearing() < 0.0) {
                    this.reverseCircle = true;
                    move = 80.0;
                    turn = 90.0;
                } else {
                    this.reverseCircle = false;
                    move = 80.0;
                    turn = -90.0;
                }
                if (this.wouldHitWall(me, this.getHeading(), move, this.getHeading() - this.myPreviousBearing)) {
                    this.reverseCircle = !this.reverseCircle;
                    move *= -1.0;
                    turn = turn == 90.0 ? -90.0 : 90.0;
                }
                this.setTurnRight(turn);
            } else {
                double turn;
                if (this.reverseCircle) {
                    move = -80.0;
                    turn = -9.0;
                } else {
                    move = 80.0;
                    turn = 9.0;
                }
                if (this.wouldHitWall(me, this.getHeading(), move, this.getHeading() - this.myPreviousBearing)) {
                    move *= -1.0;
                    this.reverseCircle = !this.reverseCircle;
                }
                this.setTurnRight(turn);
            }
        } else if (this.avoidance == 0) {
            double interceptBearing = BagPuss.normalRelativeAngle(this.bearingFromMe - this.getHeading());
            move = this.target.getDistance() / 3.0;
            this.setWiggle();
            this.setTurnRight(BagPuss.normalRelativeAngle(interceptBearing + (double)this.wiggle));
            if (this.wouldHitWall(me, this.getHeading(), move, this.getHeading() - this.myPreviousBearing)) {
                move *= -1.0;
            }
        } else {
            this.setBack(200.0);
            this.setTurnLeft(180.0);
            --this.avoidance;
            return;
        }
        if (this.target.getDistance() < 100.0) {
            move = this.target.getBearing() > -90.0 && this.target.getBearing() <= 90.0 ? (move -= 50.0) : (move += 50.0);
        }
        this.setAhead(move);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Coordinate me = new Coordinate(this.getX(), this.getY());
        if (this.target != null) {
            if (!this.wouldHitWall(me, this.getHeading(), 100.0, this.getHeading() - this.myPreviousBearing)) {
                this.avoidance = 50;
            }
        } else {
            double move = 100.0;
            if (this.wouldHitWall(me, this.getHeading(), move, this.getHeading() - this.myPreviousBearing)) {
                move *= -1.0;
            }
            this.setTurnRight(20.0);
            this.setAhead(move);
        }
    }

    public void onCustomEvent(CustomEvent event) {
        if (event.getCondition() instanceof RadarTurnCompleteCondition && this.sweepScan && event.getCondition().test()) {
            this.sweepScanCountdown = 10;
            this.sweepScan = false;
            this.firstScan = false;
            Enumeration e = this.targets.elements();
            Target newT = null;
            double fudgeFactor = 100.0;
            double newDistance = this.target == null ? 100000.0 : this.target.getDistance();
            while (e.hasMoreElements()) {
                Target t = (Target)e.nextElement();
                if (t.getEnergy() == 0.0 || t.getEnergy() <= 20.0 && t.getDistance() < 500.0) {
                    this.target = t;
                    return;
                }
                if (!(t.getDistance() + fudgeFactor < newDistance)) continue;
                newT = t;
                newDistance = t.getDistance();
            }
            if (newT != null) {
                this.target = newT;
            }
        }
    }

    private boolean doFire(double firePower) {
        if (this.getGunHeat() == 0.0 && firePower < this.getEnergy()) {
            ++this.bulletsFired;
            this.totalFirePower = (int)((double)this.totalFirePower + firePower);
            this.fire(firePower);
            return true;
        }
        return false;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ++this.bulletsMissed;
    }

    public void onBulletHit(BulletHitEvent event) {
        ++this.bulletsHit;
    }

    private void setScan() {
        if (this.targets.size() != 1 || this.target == null) {
            --this.sweepScanCountdown;
        }
        if (this.sweepScanCountdown <= 0) {
            this.sweepScan = true;
            this.setTurnRadarRight(360.0);
            this.sweepScanCountdown = 10;
            return;
        }
        if (this.target != null) {
            if (this.unsuccessfulScanCounter > 2) {
                this.unsuccessfulScanCounter = 0;
                this.isLocked = false;
                ((Robot)this).out.println("lost lock");
                this.sweepScan = true;
                this.setTurnRadarRight(360.0);
                this.sweepScanCountdown = 10;
                this.target = null;
                return;
            }
            ++this.unsuccessfulScanCounter;
            Coordinate robotPosition = new Coordinate(this.getX(), this.getY());
            double targetRadarAngle = robotPosition.headingTo(this.target.getPosition());
            double radarTurnRightAngle = BagPuss.normalRelativeAngle(targetRadarAngle - this.getRadarHeading());
            radarTurnRightAngle = radarTurnRightAngle > 0.0 ? (radarTurnRightAngle += 20.0) : (radarTurnRightAngle -= 20.0);
            this.setTurnRadarRight(radarTurnRightAngle);
        } else {
            this.sweepScan = true;
            this.setTurnRadarRight(360.0);
            this.sweepScanCountdown = 10;
        }
    }

    public void onHitWall(HitWallEvent event) {
        if (this.circling) {
            boolean bl = this.reverseCircle = !this.reverseCircle;
        }
        if (event.getBearing() > -90.0 && event.getBearing() <= 90.0) {
            this.setBack(100.0);
        } else {
            this.setAhead(100.0);
        }
        this.setTurnRight(0.0);
        this.dontMoveFor = 25;
    }

    public void onRobotDeath(RobotDeathEvent event) {
        if (this.target != null && event.getName() == this.target.getName()) {
            this.circling = false;
            this.noTarget = true;
            this.target = null;
            this.isLocked = false;
        }
        Target target = (Target)this.targets.remove(event.getName());
    }

    public void onHitRobot(HitRobotEvent event) {
        if (event.isMyFault()) {
            ((Robot)this).out.println("I rammed " + event.getName() + " hahaha!");
        } else {
            ((Robot)this).out.println("That bastard " + event.getName() + " rammed me! Get him!");
        }
        if (this.target == null) {
            return;
        }
        double angle_rad = this.getHeadingRadians() + event.getBearingRadians();
        double currentTargetPosX = this.getX() * Math.sin(angle_rad);
        double currentTargetPosY = this.getY() * Math.cos(angle_rad);
        Coordinate currentTargetPosition = new Coordinate(currentTargetPosX, currentTargetPosY);
        this.target.update(event.getName(), currentTargetPosition, 0.0, 0.0, 0.0, event.getBearing(), this.getTime(), event.getEnergy());
    }

    public void onDeath(DeathEvent e) {
        ((Robot)this).out.println("Noooooo, why did it have to end this way!");
        this.targets.clear();
        this.doStats();
    }

    static double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    double normaliseRadiansBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    boolean wouldHitWall(Coordinate pos, double bearing, double move, double angularVel) {
        Coordinate estimatedPos = pos.getNextPosition(bearing, move, angularVel);
        return estimatedPos.x < 0.0 || estimatedPos.x >= this.getBattleFieldWidth() || estimatedPos.y < 0.0 || estimatedPos.y >= this.getBattleFieldHeight();
    }

    double decideFirePower() {
        double percent = (double)this.bulletsHit / (double)this.bulletsFired * 100.0;
        double e = this.getEnergy();
        double d = this.target.getDistance();
        if (percent > 25.0 && this.getEnergy() >= 3.0) {
            return 3.0;
        }
        if (e >= 50.0) {
            return 3.0;
        }
        if (e < 0.2) {
            return 0.0;
        }
        if (e <= 2.0) {
            return 0.1;
        }
        if (e <= 6.0) {
            return 0.2;
        }
        if (e <= 20.0) {
            return 0.5;
        }
        if (d <= 80.0) {
            return 3.0;
        }
        if (d <= 100.0) {
            return 2.8;
        }
        if (d <= 140.0) {
            return 2.7;
        }
        if (d <= 150.0) {
            return 2.6;
        }
        if (d <= 160.0) {
            return 2.5;
        }
        if (d <= 170.0) {
            return 2.4;
        }
        if (d <= 180.0) {
            return 2.3;
        }
        if (d <= 190.0) {
            return 2.2;
        }
        if (d <= 200.0) {
            return 2.1;
        }
        if (d <= 210.0) {
            return 2.0;
        }
        if (d <= 220.0) {
            return 1.9;
        }
        if (d <= 230.0) {
            return 1.8;
        }
        if (d <= 240.0) {
            return 1.7;
        }
        if (d <= 250.0) {
            return 1.6;
        }
        if (d <= 260.0) {
            return 1.5;
        }
        if (d <= 270.0) {
            return 1.4;
        }
        if (d <= 280.0) {
            return 1.3;
        }
        if (d <= 290.0) {
            return 1.2;
        }
        if (d <= 300.0) {
            return 1.1;
        }
        return 1.0;
    }

    void setWiggle() {
        if (this.wiggleCount == 0) {
            this.wiggleCount = 25;
            this.wiggle = this.wiggle == 50 ? -50 : 50;
        } else {
            --this.wiggleCount;
        }
    }

    void updateTarget(Target target, ScannedRobotEvent event) {
        if (target == null) {
            return;
        }
        double angle_rad = this.getHeadingRadians() + event.getBearingRadians();
        double currentTargetPosX = this.getX() + event.getDistance() * Math.sin(angle_rad);
        double currentTargetPosY = this.getY() + event.getDistance() * Math.cos(angle_rad);
        Coordinate currentTargetPosition = new Coordinate(currentTargetPosX, currentTargetPosY);
        target.update(event.getName(), currentTargetPosition, event.getDistance(), event.getVelocity(), event.getHeading(), event.getBearing(), this.getTime(), event.getEnergy());
    }

    public void onWin(WinEvent e) {
        this.doStats();
        this.targets.clear();
        ((Robot)this).out.println("WOOHOO, I WIN SUCKERS!");
        while (true) {
            this.setTurnGunLeft(45.0);
            this.setTurnRight(45.0);
            this.fire(0.1);
        }
    }

    private void doStats() {
        double percent = (double)this.bulletsHit / (double)this.bulletsFired * 100.0;
        ((Robot)this).out.println("bullets fired: " + this.bulletsFired);
        ((Robot)this).out.println("bullets missed: " + this.bulletsMissed);
        ((Robot)this).out.println("bullets hit: " + this.bulletsHit);
        ((Robot)this).out.println("% hit: " + percent);
        ((Robot)this).out.println("average shot power:" + (double)this.totalFirePower / (double)this.bulletsFired);
        ((Robot)this).out.println("rate of fire: " + (double)this.totalTurns / (double)this.bulletsFired);
    }

    void antiGravMove() {
        double ang;
        double force;
        if (this.dontMoveFor != 0) {
            --this.dontMoveFor;
            return;
        }
        double xforce = 0.0;
        double yforce = 0.0;
        Enumeration e = this.targets.elements();
        Coordinate me = new Coordinate(this.getX(), this.getY());
        while (e.hasMoreElements()) {
            Target t = (Target)e.nextElement();
            Coordinate targetPos = t.getPosition();
            force = t.power / Math.pow(me.distanceFrom(targetPos), 2.0);
            ang = this.normaliseRadiansBearing(1.5707963267948966 - Math.atan2(this.getY() - targetPos.y, this.getX() - targetPos.x));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
        }
        ++this.midpointcount;
        if (this.midpointcount > 15) {
            this.midpointcount = 0;
            this.midpointstrength = 3500.0;
            double rX = Math.random() * this.getBattleFieldWidth();
            double rY = Math.random() * this.getBattleFieldHeight();
            this.midpoint = new Coordinate(rX, rY);
            this.jiggleAhead = !this.jiggleAhead;
        }
        force = this.midpointstrength / Math.pow(me.distanceFrom(this.midpoint), 2.0);
        ang = this.normaliseRadiansBearing(1.5707963267948966 - Math.atan2(this.getY() - this.midpoint.y, this.getX() - this.midpoint.x));
        xforce += Math.sin(ang) * force;
        yforce += Math.cos(ang) * force;
        GravPoint jigglePoint = this.jiggleAhead ? new GravPoint(this.getX() + Math.sin(this.getHeading()) * 1000.0, this.getY() + Math.cos(this.getHeading()) * 1000.0, 1000.0) : new GravPoint(this.getX() - Math.sin(this.getHeading()) * 1000.0, this.getY() - Math.cos(this.getHeading()) * 1000.0, 1000.0);
        force = jigglePoint.power / Math.pow(me.distanceFrom(new Coordinate(jigglePoint.x, jigglePoint.y)), 2.0);
        ang = this.normaliseRadiansBearing(1.5707963267948966 - Math.atan2(this.getY() - jigglePoint.y, this.getX() - jigglePoint.x));
        xforce += Math.sin(ang) * force;
        yforce += Math.cos(ang) * force;
        if (this.targets.size() != 1) {
            force = -500.0 / Math.pow(me.distanceFrom(new Coordinate(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0)), 2.0);
            ang = this.normaliseRadiansBearing(1.5707963267948966 - Math.atan2(this.getY() - this.getBattleFieldHeight() / 2.0, this.getX() - this.getBattleFieldWidth() / 2.0));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
        }
        xforce += 5000.0 / Math.pow(me.distanceFrom(new Coordinate(this.getBattleFieldWidth(), this.getY())), 3.0);
        yforce += 5000.0 / Math.pow(me.distanceFrom(new Coordinate(this.getX(), this.getBattleFieldHeight())), 3.0);
        this.goTo(new Coordinate(this.getX() - (xforce -= 5000.0 / Math.pow(me.distanceFrom(new Coordinate(0.0, this.getY())), 3.0)), this.getY() - (yforce -= 5000.0 / Math.pow(me.distanceFrom(new Coordinate(this.getX(), 0.0)), 3.0))));
    }

    void goTo(Coordinate c) {
        double dist = 20.0;
        Coordinate me = new Coordinate(this.getX(), this.getY());
        double angle = me.headingTo(c);
        double r = this.turnTo(angle);
        this.setAhead(dist * r);
    }

    int turnTo(double angle) {
        int dir;
        double ang = BagPuss.normalRelativeAngle(this.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.setTurnLeft(ang);
        return dir;
    }
}

