/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.navigation.events;

import robocode.Condition;
import robocode.Robot;

public class VelocityChangedCondition
extends Condition {
    private Robot robot;
    private double oldVelocity;
    private double newVelocity;

    public VelocityChangedCondition(Robot robot) {
        this.robot = robot;
        this.oldVelocity = this.newVelocity = robot.getVelocity();
    }

    public boolean test() {
        this.oldVelocity = this.newVelocity;
        this.newVelocity = this.robot.getVelocity();
        return this.oldVelocity != this.newVelocity;
    }

    public double getOldVelocity() {
        return this.oldVelocity;
    }

    public double getNewVelocity() {
        return this.newVelocity;
    }

    public boolean isAccelerating() {
        return Math.abs(this.oldVelocity) < Math.abs(this.newVelocity);
    }

    public boolean isDecelerating() {
        return Math.abs(this.newVelocity) < Math.abs(this.oldVelocity);
    }

    public double getChangeRate() {
        return Math.abs(this.newVelocity) - Math.abs(this.oldVelocity);
    }
}

