/*
 * Decompiled with CFR 0.152.
 */
package amk.util;

import java.io.Serializable;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class Unit
implements Serializable {
    public String name;
    public double heading;
    public double headingRads;
    public double bearing;
    public double bearingRads;
    public double velocity;
    public double distance;
    public double oldEnergy = 0.0;
    public double energy = 0.0;
    public double absX;
    public double absY;

    public Unit(ScannedRobotEvent e, AdvancedRobot bot) {
        this.name = e.getName();
        this.heading = e.getHeading();
        this.headingRads = Math.toRadians(this.heading);
        this.bearing = e.getBearing();
        this.bearingRads = Math.toRadians(this.bearing);
        this.velocity = e.getVelocity();
        this.distance = e.getDistance();
        this.energy = e.getEnergy();
        this.absX = bot.getX() + this.distance * Math.sin(this.bearingRads);
        this.absY = bot.getY() + this.distance * Math.cos(this.bearingRads);
    }

    public void update(ScannedRobotEvent e, AdvancedRobot bot) {
        this.name = e.getName();
        this.heading = e.getHeading();
        this.headingRads = Math.toRadians(this.heading);
        this.bearing = e.getBearing();
        this.bearingRads = Math.toRadians(this.bearing);
        this.velocity = e.getVelocity();
        this.distance = e.getDistance();
        this.oldEnergy = this.energy;
        this.energy = e.getEnergy();
        this.absX = bot.getX() + this.distance * Math.sin(this.bearingRads);
        this.absY = bot.getY() + this.distance * Math.cos(this.bearingRads);
    }

    public boolean hasFired() {
        double delta = this.energy - this.oldEnergy;
        return 1.0 <= delta & delta <= 3.0;
    }
}

