/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.weapon;

public class RGunStatistic {
    public double simulatedShotsFired = 0.0;
    public double simulatedShotsHit = 0.0;
    public double realShotsFired = 0.0;
    public double realShotsHit = 0.0;
    public double minPercent = -1.0;

    public double getRealHitPercent() {
        return this.realShotsFired != 0.0 ? (double)Math.round(this.realShotsHit / this.realShotsFired * 1000.0) / 10.0 : 0.0;
    }

    public double getVirtualHitPercent() {
        return this.simulatedShotsFired != 0.0 ? (double)Math.round(this.simulatedShotsHit / this.simulatedShotsFired * 1000.0) / 10.0 : 0.0;
    }

    public double getWeightedHitPercent() {
        double realPercent = this.getRealHitPercent();
        double virtualPercent = this.getVirtualHitPercent();
        double virtualWeight = 1.0;
        if (realPercent < virtualPercent) {
            virtualWeight = 20.0;
        } else if (realPercent > virtualPercent) {
            virtualWeight = 0.0;
        }
        double avePercent = (this.getRealHitPercent() + this.getVirtualHitPercent() * virtualWeight) / (virtualWeight + 1.0);
        return avePercent > this.minPercent ? avePercent : 0.0;
    }
}

