/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import justin.Enemy;
import justin.HistoryLog;
import justin.Module;
import justin.utils.DRUtils;
import justin.utils.FastTrig;
import robocode.util.Utils;

public class DCWaveDistance1v1 {
    public static final int SONAR_BINS = 25;
    public static final int MAX_SONAR_DIST = 400;
    public static final int SONAR_MIDDLE_BIN = 12;
    public static final int DIMENSIONS_1V1 = 8;
    private static final double[] wieghts1vrs1 = new double[]{4.0, 4.0, 1.0, 2.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};

    public static final double[] get(Enemy e, Module bot) {
        return DCWaveDistance1v1.get(e, e, bot);
    }

    public static final double[] get(Enemy me, Enemy e, Module bot) {
        double[] p = new double[8];
        p[0] = Math.abs(me.velocity) / 8.0;
        p[1] = DRUtils.getWallDist(me.location, me.correctedHeadingRadians, Module.bw, Module.bh);
        p[2] = DRUtils.getWallDist(me.location, Utils.normalAbsoluteAngle((double)(me.correctedHeadingRadians + Math.PI)), Module.bw, Module.bh);
        p[3] = 0.5;
        if (Math.abs(me.velocity) > Math.abs(me.previousVelocity)) {
            p[4] = 1.0;
        } else if (Math.abs(me.previousVelocity) < Math.abs(me.velocity)) {
            p[4] = 0.0;
        }
        p[4] = me == e ? Math.abs(Utils.normalRelativeAngle((double)(me.headingRadians - Module.myData.headingRadians - me.bearingRadians))) / Math.PI : 0.0;
        p[5] = Math.min(me.tSDC, 120.0) / 120.0;
        double distance10 = 0.0;
        HistoryLog history = e.last;
        while (history.previous != null && distance10 < 10.0) {
            history = history.previous;
            distance10 += 1.0;
        }
        p[6] = Math.min(history.distance, 1200.0) / 1200.0;
        while (history.previous != null && distance10 < 10.0) {
            history = history.previous;
            distance10 += 1.0;
        }
        p[7] = Math.min(history.distance, 1200.0) / 1200.0;
        int i = 0;
        while (i < 8) {
            p[i] = p[i] * wieghts1vrs1[i];
            ++i;
        }
        return p;
    }

    public static double[] getSonar(Enemy e, Module bot) {
        Point2D.Double testLoc;
        double angle;
        Graphics2D g = bot.getGraphics();
        double[] sonar = new double[25];
        double sliceSize = 0.25132741228718347;
        double testDist = 400.0;
        int i = 0;
        while (i < 25) {
            angle = e.correctedHeadingRadians + Math.PI + sliceSize / 2.0 + (double)i * sliceSize;
            testLoc = FastTrig.project(e.location, angle, 400.0);
            testLoc.x = DRUtils.limit(18.0, testLoc.x, Module.bw - 18.0);
            testLoc.y = DRUtils.limit(18.0, testLoc.y, Module.bh - 18.0);
            sonar[i] = testDist = e.location.distance(testLoc);
            ++i;
        }
        for (Enemy o : Module.enemies.values()) {
            if (!o.alive || o.location == null) continue;
            angle = Utils.normalRelativeAngle((double)(DRUtils.absoluteBearing(e.location, o.location) - e.correctedHeadingRadians));
            double factor = Utils.normalRelativeAngle((double)angle) / Math.PI;
            int bin = (int)DRUtils.limit(0.0, Math.round(12.0 + factor * 12.0), 24.0);
            testDist = e.location.distance(o.location) * 0.5;
            if (!(testDist < sonar[bin])) continue;
            sonar[bin] = testDist;
        }
        int i2 = 0;
        while (i2 < 25) {
            angle = e.correctedHeadingRadians + Math.PI + sliceSize / 2.0 + (double)i2 * sliceSize;
            testLoc = FastTrig.project(e.location, angle, sonar[i2]);
            testLoc.x = DRUtils.limit(18.0, testLoc.x, Module.bw - 18.0);
            testLoc.y = DRUtils.limit(18.0, testLoc.y, Module.bh - 18.0);
            g.setColor(Color.yellow);
            String s = "" + i2;
            g.drawString(s, (int)testLoc.x - 3, (int)testLoc.y - 3);
            ++i2;
        }
        return sonar;
    }
}

