/*
 * Decompiled with CFR 0.152.
 */
package eem.wave;

import eem.bot.InfoBot;
import eem.misc.graphics;
import eem.misc.logger;
import eem.misc.physics;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class wave {
    public InfoBot firedBot = null;
    protected Point2D.Double firedPosition;
    protected long firedTime;
    protected double bulletSpeed;
    protected double bulletEnergy;
    protected long timeUncertaintyLower = 0L;
    protected Color waveColor = new Color(255, 0, 0, 128);
    protected Color waveUncertaintyColorLower = new Color(0, 0, 255, 128);

    public wave(InfoBot infoBot, long l, double d) {
        this.firedBot = infoBot;
        this.firedTime = l;
        this.bulletEnergy = d;
        this.bulletSpeed = physics.bulletSpeed(d);
        Point2D.Double double_ = infoBot.getPositionAtTime(l);
        if (double_ != null) {
            this.firedPosition = (Point2D.Double)double_.clone();
            this.timeUncertaintyLower = 0L;
        } else {
            this.firedPosition = (Point2D.Double)infoBot.getLast().getPosition().clone();
            this.timeUncertaintyLower = l - infoBot.getPrev().getTime();
            logger.noise("timeUncertaintyLower = " + this.timeUncertaintyLower);
        }
    }

    public InfoBot getFiredBot() {
        return this.firedBot;
    }

    public long getFiredTime() {
        return this.firedTime;
    }

    public double getBulletEnergy() {
        return this.bulletEnergy;
    }

    public double getDistanceTraveledAtTime(long l) {
        double d = l - this.firedTime;
        double d2 = d * this.bulletSpeed;
        return d2;
    }

    public boolean isBehindBot(InfoBot infoBot, long l) {
        double d;
        double d2 = this.getDistanceTraveledAtTime(l);
        Point2D.Double double_ = infoBot.getPosition(l);
        if (double_ == null) {
            double_ = infoBot.getLast().getPosition();
        }
        return d2 > (d = double_.distance(this.firedPosition)) + (double)physics.robotHalfSize;
    }

    public boolean equals(wave wave2) {
        boolean bl = true;
        if (!this.getFiredBot().getName().equals(wave2.getFiredBot().getName())) {
            return false;
        }
        if (this.getFiredTime() != wave2.getFiredTime()) {
            return false;
        }
        if (this.getBulletEnergy() != wave2.getBulletEnergy()) {
            return false;
        }
        if (this.firedPosition.x != wave2.firedPosition.x) {
            return false;
        }
        return this.firedPosition.y == wave2.firedPosition.y;
    }

    public void onPaint(Graphics2D graphics2D, long l) {
        graphics2D.setColor(this.waveColor);
        double d = this.getDistanceTraveledAtTime(l);
        graphics.drawCircle(graphics2D, this.firedPosition, d);
        if (this.timeUncertaintyLower != 0L) {
            graphics2D.setColor(this.waveUncertaintyColorLower);
            graphics.drawCircle(graphics2D, this.firedBot.getPositionAtTime(this.firedTime - this.timeUncertaintyLower), d + this.bulletSpeed * (double)this.timeUncertaintyLower);
        }
    }
}

