/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Snapshot;
import pedersen.debug.Debug;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVelocity;
import pedersen.physics.StaticVelocityImpl;
import pedersen.physics.Wave;

public abstract class WaveBase
implements Wave {
    protected final StaticPosition position;
    protected final StaticVelocity velocity;
    private final long timeOfCreation;

    public WaveBase(double _x, double _y, double _v, long timeOfCreation) {
        this.position = new StaticPositionImpl(_x, _y);
        this.velocity = new StaticVelocityImpl(_v);
        this.timeOfCreation = timeOfCreation;
    }

    public WaveBase(StaticPosition newPosition, double _v, long timeOfCreation) {
        this.position = new StaticPositionImpl(newPosition);
        this.velocity = new StaticVelocityImpl(_v);
        this.timeOfCreation = timeOfCreation;
    }

    public WaveBase(Snapshot snapshot, double _v, long timeOfCreation) {
        this.position = snapshot;
        this.velocity = new StaticVelocityImpl(_v);
        this.timeOfCreation = timeOfCreation;
    }

    public double getRadius(long time) {
        return this.velocity.getVelocity() * (double)(time - this.timeOfCreation);
    }

    public long getTimeOfCreation() {
        return this.timeOfCreation;
    }

    public void debug() {
        Debug.debug("Wave base:");
        this.position.debug();
        this.velocity.debug();
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public boolean equalsPosition(StaticPosition other) {
        return this.position.equalsPosition(other);
    }

    public StaticPosition getRelativePosition(StaticPosition other) {
        return this.position.getRelativePosition(other);
    }

    public StaticVector getRelativeVector(StaticPosition other) {
        return this.position.getRelativeVector(other);
    }

    public double getBearing(StaticPosition other) {
        return this.position.getBearing(other);
    }

    public double getDistance(StaticPosition other) {
        return this.position.getDistance(other);
    }

    public double getVelocity() {
        return this.velocity.getVelocity();
    }

    public boolean equalsVelocity(double other) {
        return this.velocity.equalsVelocity(other);
    }

    public boolean equalsVelocity(StaticVelocity other) {
        return this.velocity.equalsVelocity(other);
    }

    public double getRelativeVelocity(double other) {
        return this.velocity.getRelativeVelocity(other);
    }

    public double getRelativeVelocity(StaticVelocity other) {
        return this.velocity.getRelativeVelocity(other);
    }

    public double getCompoundVelocity(double other) {
        return this.velocity.getCompoundVelocity(other);
    }

    public double getCompoundVelocity(StaticVelocity other) {
        return this.velocity.getCompoundVelocity(other);
    }
}

