/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.misc.Arena;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.tactics.grail.Grid;

public class GridSector
implements Debuggable {
    private final StaticPosition center;
    private final boolean isInBounds;
    private GridSector north = null;
    private GridSector northeast = null;
    private GridSector southeast = null;
    private GridSector south = null;
    private GridSector southwest = null;
    private GridSector northwest = null;
    private boolean areNeighborsGenerated = false;
    public static final double radius = 18.0 * Math.sqrt(2.0);
    private static final double distance = 2.0 * radius;
    private static final double n = 0.0;
    private static final double ne = 1.0471975511965976;
    private static final double se = 2.0943951023931953;
    private static final double s = Math.PI;
    private static final double sw = 4.1887902047863905;
    private static final double nw = 5.235987755982988;

    public GridSector(StaticPosition position) {
        this.center = position;
        this.isInBounds = Arena.isVehicleCenterInBoundary(this.center);
        if (this.isInBounds) {
            Grid.singleton.add(this);
        }
    }

    public GridSector(StaticPosition other, double heading) {
        this.center = new StaticPositionImpl(other, heading, distance);
        this.isInBounds = Arena.isVehicleCenterInBoundary(this.center);
        if (this.isInBounds) {
            Grid.singleton.add(this);
        }
    }

    public void generateNeighborConnections() {
        if (this.isInBounds) {
            if (this.north == null && this.northwest != null) {
                this.north = this.northwest.getNortheast();
            }
            if (this.north == null && this.northeast != null) {
                this.north = this.northeast.getNorthwest();
            }
            if (this.north == null) {
                this.north = new GridSector(this.center, 0.0);
            }
            if (this.northeast == null && this.north != null) {
                this.northeast = this.north.getSoutheast();
            }
            if (this.northeast == null && this.southeast != null) {
                this.northeast = this.southeast.getNorth();
            }
            if (this.northeast == null) {
                this.northeast = new GridSector(this.center, 1.0471975511965976);
            }
            if (this.southeast == null && this.northeast != null) {
                this.southeast = this.northeast.getSouth();
            }
            if (this.southeast == null && this.south != null) {
                this.southeast = this.south.getNortheast();
            }
            if (this.southeast == null) {
                this.southeast = new GridSector(this.center, 2.0943951023931953);
            }
            if (this.south == null && this.southeast != null) {
                this.south = this.southeast.getSouthwest();
            }
            if (this.south == null && this.southwest != null) {
                this.south = this.southwest.getSoutheast();
            }
            if (this.south == null) {
                this.south = new GridSector(this.center, Math.PI);
            }
            if (this.southwest == null && this.south != null) {
                this.southwest = this.south.getNorthwest();
            }
            if (this.southwest == null && this.northwest != null) {
                this.southwest = this.northwest.getSouth();
            }
            if (this.southwest == null) {
                this.southwest = new GridSector(this.center, 4.1887902047863905);
            }
            if (this.northwest == null && this.southwest != null) {
                this.northwest = this.southwest.getNorth();
            }
            if (this.northwest == null && this.north != null) {
                this.northwest = this.north.getSouthwest();
            }
            if (this.northwest == null) {
                this.northwest = new GridSector(this.center, 5.235987755982988);
            }
            if (this.north != null) {
                this.north.setSouth(this);
            }
            if (this.northeast != null) {
                this.northeast.setSouthwest(this);
            }
            if (this.southeast != null) {
                this.southeast.setNorthwest(this);
            }
            if (this.south != null) {
                this.south.setNorth(this);
            }
            if (this.southwest != null) {
                this.southwest.setNortheast(this);
            }
            if (this.northwest != null) {
                this.northwest.setSoutheast(this);
            }
        }
        this.areNeighborsGenerated = true;
    }

    public GridSector getNorth() {
        return this.north;
    }

    public GridSector getNortheast() {
        return this.northeast;
    }

    public GridSector getSoutheast() {
        return this.southeast;
    }

    public GridSector getSouth() {
        return this.south;
    }

    public GridSector getSouthwest() {
        return this.southwest;
    }

    public GridSector getNorthwest() {
        return this.northwest;
    }

    public void setNorth(GridSector other) {
        this.north = other;
    }

    public void setNortheast(GridSector other) {
        this.northeast = other;
    }

    public void setSoutheast(GridSector other) {
        this.southeast = other;
    }

    public void setSouth(GridSector other) {
        this.south = other;
    }

    public void setSouthwest(GridSector other) {
        this.southwest = other;
    }

    public void setNorthwest(GridSector other) {
        this.northwest = other;
    }

    public StaticPosition getCenter() {
        return this.center;
    }

    public boolean areNeighborsGenerated() {
        return this.areNeighborsGenerated;
    }

    public boolean isInBounds() {
        return this.isInBounds;
    }

    public void disassociate() {
        if (this.north != null) {
            this.north.setSouth(null);
            this.north = null;
        }
        if (this.northeast != null) {
            this.northeast.setSouthwest(null);
            this.northeast = null;
        }
        if (this.southeast != null) {
            this.southeast.setNorthwest(null);
            this.southeast = null;
        }
        if (this.south != null) {
            this.south.setNorth(null);
            this.south = null;
        }
        if (this.southwest != null) {
            this.southwest.setNortheast(null);
            this.southwest = null;
        }
        if (this.northwest != null) {
            this.northwest.setSoutheast(null);
            this.northwest = null;
        }
    }

    public void debug() {
        Debug.debug("GridSector: ( " + Debug.trim(this.center.getX()) + ", " + Debug.trim(this.center.getY()) + " )");
        Debug.debug("isInBounds: " + this.isInBounds);
    }
}

