/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.strategy.movement;

import de.simpleworks.robocode.botUtil.Coordinate;
import de.simpleworks.robocode.botUtil.CsCalc;
import de.simpleworks.robocode.bots.swiBot;
import de.simpleworks.robocode.strategy.movement.MSSimpleRun;

public class MSBorderMove
extends MSSimpleRun {
    private static final int BORDER_WID = 100;
    Coordinate[] FBorderPoints = new Coordinate[8];
    private int FCurPoint = 0;
    private boolean FBPInited = false;

    private boolean isInBorderPos(swiBot _bot) {
        Coordinate myPoint = new Coordinate(_bot.getX(), _bot.getY());
        this.initBorderPoints(_bot);
        int i = 0;
        while (i < this.FBorderPoints.length) {
            if (myPoint.x() == this.FBorderPoints[i].x() && myPoint.y() == this.FBorderPoints[i].y()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Coordinate getNearestBorderPos(swiBot _bot) {
        this.initBorderPoints(_bot);
        this.FCurPoint = 0;
        Coordinate res = this.FBorderPoints[1];
        Coordinate startPoint = new Coordinate(_bot.getX(), _bot.getY());
        int i = 1;
        while (i < 8) {
            double dist1 = CsCalc.calcDistance(startPoint, res);
            double dist2 = CsCalc.calcDistance(startPoint, this.FBorderPoints[i]);
            if (dist2 < dist1) {
                res = this.FBorderPoints[i];
                this.FCurPoint = i;
            }
            ++i;
        }
        return res;
    }

    private void initBorderPoints(swiBot _bot) {
        if (!this.FBPInited) {
            double bfWid = _bot.getBattleFieldWidth();
            double bfHeight = _bot.getBattleFieldHeight();
            this.FBorderPoints[0] = new Coordinate(50.0, 50.0);
            this.FBorderPoints[1] = new Coordinate(50.0, bfHeight / 2.0);
            this.FBorderPoints[2] = new Coordinate(50.0, bfHeight - 50.0);
            this.FBorderPoints[3] = new Coordinate(bfWid / 2.0, bfHeight - 50.0);
            this.FBorderPoints[4] = new Coordinate(bfWid - 50.0, bfHeight - 50.0);
            this.FBorderPoints[5] = new Coordinate(bfWid - 50.0, bfHeight - bfHeight / 2.0);
            this.FBorderPoints[6] = new Coordinate(bfWid - 50.0, 50.0);
            this.FBorderPoints[7] = new Coordinate(50.0, 50.0);
            this.FBPInited = true;
        }
    }

    private Coordinate getNextPPoint() {
        ++this.FCurPoint;
        if (this.FCurPoint >= this.FBorderPoints.length) {
            this.FCurPoint = 0;
        }
        return this.FBorderPoints[this.FCurPoint];
    }

    @Override
    public void execDefaultPattern(swiBot _bot) {
        if (!this.isInBorderPos(_bot)) {
            _bot.moveToDirect(this.getNearestBorderPos(_bot), 150.0);
        } else {
            _bot.moveToDirect(this.getNextPPoint(), 150.0);
        }
    }
}

