package awesomeness;

import robocode.*;
import robocode.util.*;
import java.util.Random;
import java.awt.Color;

/**
 * Elite - a robot by Awesomeness
 */
public class Elite extends AdvancedRobot {
	
	static double previousEnergy = 100d;
	static double changeInEnergy;
	static int movementDirection = 50;
	static int alternate;
	static Random generator = new Random(); //This makes random numbers
	
	/**
	 * run: Elite's default behavior
	 */
	public void run() {
		
		// body = black, gun = white, radar = red
		setColors(Color.black, Color.gray, Color.orange);
		setBulletColor(Color.yellow);
		
		setAdjustGunForRobotTurn(true);
		
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		
		//The absolute bearing, this is used a lot
		double absoluteBearing = e.getBearingRadians();
		
		///////////////////////////////////////////////////////
		////////////////////Movement Code//////////////////////
		
		//If there's a change in energy, it probably fired

		
		if ((changeInEnergy = previousEnergy - (previousEnergy = e.getEnergy())) > 0d && changeInEnergy<=4) {
			i();
			alternate ++;
			if (alternate >= generator.nextInt(5)+1) {
				i();
				alternate = 0;
			}
		}
		
							
		// Stay at right angles to the opponent	
		//setTurnRight(e.getBearing()+90d);
		setTurnRightRadians(Math.cos(absoluteBearing+(-0.003*movementDirection))); // Simonton-ish way. one byte smaller	
	
		
		//setMaxVelocity(8);
		
		setAhead(movementDirection);
		
		// Track the energy level
		previousEnergy = e.getEnergy();
		
		////////////////////Movement Code//////////////////////
		///////////////////////////////////////////////////////
		
		///////////////////////////////////////////////////////
		///////////////////////Gun Code////////////////////////
		
		//Pretty simple...
		setTurnGunRightRadians(Utils.normalRelativeAngle((absoluteBearing += getHeadingRadians()) - 
    		getGunHeadingRadians() + (e.getVelocity() * Math.sin(e.getHeadingRadians() - 
    		absoluteBearing) / 13.2)));
		if (getGunHeat() == 0d) { // Only try to fire if we can-
			setFire(2d); // otherwise we do much worse
		}

		
		///////////////////////Gun Code////////////////////////
		///////////////////////////////////////////////////////
		
		
		
		///////////////////////////////////////////////////////
		/////////////////////Radar Code////////////////////////
			
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
		
		
		/////////////////////Radar Code////////////////////////
		///////////////////////////////////////////////////////	
		
		
		
	}

	public void onHitWall(HitWallEvent e) {
		i();
	}
	
	public void i() {
		//setMaxVelocity(0);
		movementDirection = -movementDirection;
	}
}												