package shinh;

import robocode.*;

public class MoveRollReflection extends Move {
	private Enemy enemy_;

	public String name() {
		return "roll reflection";
	}

	public MoveRollReflection() {
		init();
	}

	public void init() {
		ent = Entangled.me;

		enemy_ = null;
	}

	public boolean isValid() {
		if (enemy_ != null && enemy_.distance < 300) return false;
		if (ent.nearWall(100)) return false;
		return true;
	}

	public void update() {
		if (ent.getDistanceRemaining() == 0) {
			ent.setTurnRightRadians(1000);
		}

		if (enemy_ == null) {
			if (ent.target != null)	enemy_ = ent.target;
			else return;
		}

		if (ent.bmgr.isEmpty()) return;

		while (!ent.bmgr.isEmpty() &&
			   ent.bmgr.getBullet(0).hitTurn < ent.getTime()) {
			ent.bmgr.remove(0);
		}

		if (ent.bmgr.isEmpty()) return;

		EnemyBullet eb = ent.bmgr.getBullet(0);
		double d = Util.distance2(eb.x, eb.y, ent.getX(), ent.getY());

		if (Const.REFLECT2_BULLET_DODGE2 < d) return;

		double r = Math.abs(Util.getNormalRadian(
								enemy_.radian - ent.getHeadingRadians()));
		if (r > Const.PI_2 - Const.PI_8 && r < Const.PI_2 + Const.PI_8)
		{
			if (ent.getDistanceRemaining() == 0) {
				double rr = ent.getHeadingRadians();
				double dr = distanceRateToWall(ent.getX(), ent.getY(), rr);
				double rl = Util.getRoboRadian(rr - Const.PI);
				double dl = distanceRateToWall(ent.getX(), ent.getY(), rl);

				double ahead = (1.5+Math.random())*Const.REFLECT_ONE_TIME_MOVE;

				if (dr > 300 && dl > 300) {
					if (Math.random() < 0.5) ahead = -ahead;
				}
				else {
					if (dr < dl) ahead = -ahead;
				}

				ent.setAhead(ahead);

				ent.setTurnRightRadians(0);
			}

			ent.bmgr.remove(0);
		}
		else if (Const.REFLECT_BULLET_DODGE2 > d) {
			if (ent.getDistanceRemaining() == 0) {
				if (r > Const.PI_2)
					ent.setAhead(
						(1+Math.random())*Const.REFLECT_ONE_TIME_MOVE);
				else
					ent.setBack(
						(1+Math.random())*Const.REFLECT_ONE_TIME_MOVE);

				ent.setTurnRightRadians(Const.PI_2);
			}

			ent.bmgr.remove(0);
		}
	}

}

