package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;

public class SmearQueerTargetChooser extends TargetChooser implements java.io.Serializable
{
	private String[] robotnames;
	private int[] queerFactors;
	
	public SmearQueerTargetChooser(AdvancedRobot robot, EnemyManager manager)
	{
		super(robot, manager);
		robotnames = new String[robot.getOthers()];
		queerFactors = new int[robotnames.length];
	}
	
	public void onEvent(Event e)
	{
		if (e instanceof RobotDeathEvent)
		{
			String name = ((RobotDeathEvent)e).getName();
			int others = robot.getOthers();
			logFactor(name, others*others);
		}
	}
	
	private void logFactor(String name, int factor)
	{
		for (int i=0; i<robotnames.length; i++)
			if (robotnames[i] == null)
			{
				robotnames[i] = name;
				queerFactors[i] = factor;
				break;
			}
			else if (robotnames[i].equals(name))
			{
				queerFactors[i] += factor;
				break;
			}
	}

	public EnemyState chooseTarget()
	{	
		EnemyState closest = manager.getClosestEnemy();
		if (closest == null || closest.isDead() || closest.getTimeElapsed(robot.getTime()) > 20)
			return null;
		for (int i=0; i<manager.countEnemies(); i++)
		{
			EnemyState enemy = manager.getEnemyAt(i);
			if (enemy == null || enemy.isDead() || enemy.getTimeElapsed(robot.getTime()) > 20 || enemy.getTimeElapsed(robot.getTime()) < 0)
				continue;
			if (closest.getTimeElapsed(robot.getTime()) < 0)
				closest = enemy;
			else if (getFactor(closest.getName()) < getFactor(enemy.getName()))
				closest = enemy;
		}
		return closest;
	}

	public int getFactor(String name)
	{
		for (int i=0; i<robotnames.length; i++)
			if (robotnames[i] == null)
				return 0;
			else if (robotnames[i].equals(name))
				return queerFactors[i];
		return 0;
	}
}