package sgp;
import robocode.*;
import java.util.*;
import java.lang.String;

/**
 * TargetWeight - a class by Simon Parker
 */

public class TargetWeight extends Object
{
	public Coordinate robotPosition = null;
	public double robotHeading = 0;

	public double kDistance = 0;
	public double kHeadingDifference = 0;
	public double kEnergy = 0;
	public double kDeltaEnergyEstimate = 0;
	public double kDeathPerRound = 0;
	public double kDamageInflictedPerRound = 0;
	public double kDamageSustainedPerRound = 0;
	public double kTimeSinceLastScanned = 0;
	public double kVelocity = 0;
	public double kLastBulletPower = 0;
	public double kTimeSinceLastBulletHit = 0;
	public double kAngularVelocity = 0;
	public double kClosestRobotDistance = 0;
	public double kHitRate = 0;
	public double kPredictionError = 0;

	public TargetWeight(Coordinate rPosition, double rHeading)
	{
		robotPosition = rPosition;
		robotHeading = rHeading;
	}
	
	public void reset()
	{
		kDistance = 0;
		kHeadingDifference = 0;
		kEnergy = 0;
		kDeltaEnergyEstimate = 0;
		kDeathPerRound = 0;
		kDamageInflictedPerRound = 0;
		kDamageSustainedPerRound = 0;
		kTimeSinceLastScanned = 0;
		kVelocity = 0;
		kLastBulletPower = 0;
		kTimeSinceLastBulletHit = 0;
		kAngularVelocity = 0;
		kClosestRobotDistance = 0;
		kHitRate = 0;
		kPredictionError = 0;
	}

}
