/*
 * Decompiled with CFR 0.152.
 */
package drm.common3;

import drm.common3.Coordinate;
import drm.common3.Mech;
import drm.common3.Utils;
import robocode.AdvancedRobot;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Radar
extends Mech {
    public static final int STATE_FREE = 0;
    public static final int STATE_AIMED = 1;
    double rightAbsDeg;
    double leftAbsDeg;
    int state;
    Coordinate targetPoint;
    boolean targetScannedFlg;
    double freeDegMin;
    double freeDegMax;
    double freeDegDelta;
    boolean freeRevFlg;
    double width;
    double height;

    public void initialize() {
        this.width = this.robot.getBattleFieldWidth();
        this.height = this.robot.getBattleFieldHeight();
    }

    public void setTargetPoint(double x, double y) {
        this.targetPoint.x = x;
        this.targetPoint.y = y;
        double absB = Utils.calcAbsoluteBearing(this.robot.getX(), this.robot.getY(), x, y);
        this.rightAbsDeg = Utils.normalAbsoluteAngle(absB + Utils.getRadarMaxTurning() / (double)2);
        this.leftAbsDeg = Utils.normalAbsoluteAngle(absB - Utils.getRadarMaxTurning() / (double)2);
        this.targetScannedFlg = true;
    }

    public Coordinate getTargetPoint() {
        return this.targetPoint;
    }

    public void resetTargetPoint() {
        this.targetPoint.x = 0.0;
        this.targetPoint.y = 0.0;
        this.rightAbsDeg = 0.0;
        this.leftAbsDeg = 0.0;
        this.targetScannedFlg = false;
    }

    public void move() {
        this.scan();
    }

    void scan() {
        switch (this.state) {
            case 0: {
                this.freeScan();
                break;
            }
            case 1: {
                this.aimedScan();
                break;
            }
        }
        this.state = this.rightAbsDeg != 0.0 || this.leftAbsDeg != 0.0 ? 1 : 0;
    }

    void freeScan() {
        this.calcFreeDeg();
        double nowHeading = Utils.normalAbsoluteAngle(this.robot.getRadarHeading() - this.freeDegDelta);
        if (nowHeading < this.freeDegMin && this.freeRevFlg) {
            this.freeRevFlg ^= true;
        }
        if (nowHeading > this.freeDegMax && !this.freeRevFlg) {
            this.freeRevFlg ^= true;
        }
        double deg = Utils.getRadarMaxTurning();
        if (this.freeRevFlg) {
            deg = -deg;
        }
        this.robot.setTurnRadarRight(deg);
    }

    void calcFreeDeg() {
        this.freeDegMin = 0.0;
        this.freeDegMax = 360.0;
        this.freeDegDelta = 0.0;
        double robotR = Utils.getRobotR() * (double)2;
        double x = this.robot.getX();
        double y = this.robot.getY();
        if (x < robotR) {
            this.freeDegMin = 90.0;
            this.freeDegMax = 270.0;
            this.freeDegDelta = 270.0;
        } else if (x > this.width - robotR) {
            this.freeDegMin = 90.0;
            this.freeDegMax = 270.0;
            this.freeDegDelta = 90.0;
        }
        if (y < robotR) {
            if (x < robotR) {
                this.freeDegMax = 180.0;
                this.freeDegDelta = 270.0;
            } else if (x > this.width - robotR) {
                this.freeDegMax = 180.0;
                this.freeDegDelta = 180.0;
            } else {
                this.freeDegMin = 90.0;
                this.freeDegMax = 270.0;
                this.freeDegDelta = 180.0;
            }
        } else if (y > this.height - robotR) {
            if (x < robotR) {
                this.freeDegMax = 180.0;
                this.freeDegDelta = 0.0;
            } else if (x > this.width - robotR) {
                this.freeDegMax = 180.0;
                this.freeDegDelta = 90.0;
            } else {
                this.freeDegMin = 90.0;
                this.freeDegMax = 270.0;
                this.freeDegDelta = 0.0;
            }
        }
    }

    void aimedScan() {
        double dl;
        double dr = Math.abs(Utils.normalRelativeAngle(this.robot.getRadarHeading() - this.rightAbsDeg));
        if (dr > (dl = Math.abs(Utils.normalRelativeAngle(this.robot.getRadarHeading() - this.leftAbsDeg)))) {
            this.robot.setTurnRadarRight(Math.min(dr, Utils.getRadarMaxTurning()));
        } else {
            this.robot.setTurnRadarLeft(Math.min(dl, Utils.getRadarMaxTurning()));
        }
        if (!this.targetScannedFlg) {
            this.rightAbsDeg = 0.0;
            this.leftAbsDeg = 0.0;
        }
        this.targetScannedFlg = false;
    }

    private final /* synthetic */ void this() {
        this.rightAbsDeg = 0.0;
        this.leftAbsDeg = 0.0;
        this.state = 0;
        this.targetPoint = new Coordinate();
        this.targetScannedFlg = false;
        this.freeDegMin = 0.0;
        this.freeDegMax = 360.0;
        this.freeDegDelta = 0.0;
        this.freeRevFlg = false;
    }

    public Radar() {
        this.this();
    }

    public Radar(AdvancedRobot r) {
        super(r);
        this.this();
    }
}

