/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.AdvancedRobotAdapter;
import agd.util.Enemy;
import agd.util.EnemyStats;
import agd.util.RobotInformation;
import agd.util.RollingAverage;
import agd.util.World;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobocodeFileWriter;
import robocode.WinEvent;

public class Stats {
    public static final Stats STATS = new Stats();
    RobotEventListener eventListener = new RobotEventListener();
    RobotInformation eventSource = null;
    private RollingAverage skippedTurnsPerRound = new RollingAverage();
    private RollingAverage turnsPerSkippedTurn = new RollingAverage();
    private RollingAverage avTurnProcessingTime = new RollingAverage();
    private Map enemies = null;
    private Map bulletAimedAt = null;
    private RollingAverage shotPower;
    private RollingAverage survivorPosition = new RollingAverage();
    private int[] survivorDistribution;
    private int totalEnemies = 0;

    public void registerEventSource(RobotInformation ri) {
        this.eventSource = ri;
        ri.addListener(this.eventListener);
    }

    private Stats() {
        this.enemies = new HashMap();
        this.bulletAimedAt = new HashMap();
        this.shotPower = new RollingAverage();
    }

    public RollingAverage getSkippedTurnsPerRound() {
        return this.skippedTurnsPerRound;
    }

    public RollingAverage getTurnsPerSkippedTurn() {
        return this.turnsPerSkippedTurn;
    }

    public RollingAverage getAverageTurnProcessingTime() {
        return this.avTurnProcessingTime;
    }

    public void fired(Enemy enemy, Bullet bullet) {
        if (enemy == null) {
            System.out.println("Stats.fired() given null enemy");
        }
        if (bullet == null) {
            System.out.println("Stats.fired() given null bullet");
        }
        if (this.shotPower == null) {
            System.out.println("Stats.fired() - shotPower is null");
        }
        this.shotPower.nextValue(bullet.getPower());
        this.bulletAimedAt.put(bullet, enemy.getName());
    }

    public Enemy getBulletsTarget(Bullet b) {
        Enemy target = null;
        if (this.bulletAimedAt.containsKey(b)) {
            target = (Enemy)this.bulletAimedAt.get(b);
        }
        return target;
    }

    EnemyStats getEnemyStats(String name) {
        EnemyStats stats = null;
        if (this.enemies.containsKey(name)) {
            stats = (EnemyStats)this.enemies.get(name);
        } else {
            stats = new EnemyStats(name);
            this.enemies.put(name, stats);
        }
        return stats;
    }

    public String enemyStatsReport() {
        NumberFormat tdp = NumberFormat.getInstance();
        tdp.setMaximumFractionDigits(2);
        StringBuffer sb = new StringBuffer(300);
        Iterator i = this.enemies.values().iterator();
        sb.append("Robot name\t\tHit Us\tHit them\tDamaged us\tDamaged them\tDamage ratio\n");
        while (i.hasNext()) {
            EnemyStats es = (EnemyStats)i.next();
            sb.append(es.name + "\t" + es.hitUs + "\t" + es.hitThem + "\t" + tdp.format(es.damageOnUs) + "\t" + tdp.format(es.damageOnThem) + "\t" + tdp.format(es.damageRatio) + "\n");
        }
        return sb.toString();
    }

    String reportPredictionAccuracyHtml() {
        EnemyStats e;
        StringBuffer report = new StringBuffer(800);
        report.append("<a name=movepredict><h3>Movement prediction accuracies</h3></a><br>\n");
        Iterator i = this.enemies.values().iterator();
        int count = 1;
        while (i.hasNext()) {
            e = (EnemyStats)i.next();
            report.append("<a href=#pred_acc" + count + ">" + e.getName() + "</a>");
            ++count;
            if (!i.hasNext()) continue;
            report.append(" | ");
        }
        report.append("<br>\n");
        i = this.enemies.values().iterator();
        count = 1;
        while (i.hasNext()) {
            e = (EnemyStats)i.next();
            report.append("<a name=pred_acc" + count + ">");
            report.append(e.reportPredictionAccuracyHtml(false));
            report.append(e.reportPredictionAccuracyHtml(true));
            report.append("</a><br>\n");
            ++count;
        }
        return report.toString();
    }

    public String reportShotAccuracyHtml() {
        StringBuffer report = new StringBuffer(400);
        Iterator i = this.enemies.values().iterator();
        report.append("<a name=shotaccuracy><h3>Shot accuracy</h3></a>\n");
        report.append("Fired " + this.shotPower.getCount() + " shots, average power " + this.shotPower.getAverage() + "<br>\n");
        report.append("<table><caption>Our accuracy by target</caption>\n");
        report.append("<tr><th>Robot</th><th>Shots</th><th>Hit %</th></tr>\n");
        while (i.hasNext()) {
            EnemyStats e = (EnemyStats)i.next();
            RollingAverage accuracy = e.getOurAccuracy();
            report.append("<tr><td>" + e.getName() + "</td><td>" + accuracy.getCount() + "</td><td>" + (int)(accuracy.getAverage() * 100.0) + "</td></tr>\n");
        }
        report.append("</table>\n");
        return report.toString();
    }

    String reportProcessingTimes() {
        StringBuffer o = new StringBuffer(300);
        o.append("<a name=proctimes><h3>Turn processing times</h3></a><br>");
        o.append("Statistics over " + this.avTurnProcessingTime.getCount() + " turns.<br>\n");
        o.append("<table><tr><th></th><th>Minimum</th><th>Average</th><th>Maximum</th></tr>\n");
        o.append("<tr><td>Turn processing time</td><td>" + (int)this.avTurnProcessingTime.getMin() + "ms</td><td>");
        o.append((int)this.avTurnProcessingTime.getAverage() + "ms</td><td>");
        o.append((int)this.avTurnProcessingTime.getMax() + "ms</td></tr>\n");
        RollingAverage skippedPerRound = this.getSkippedTurnsPerRound();
        RollingAverage turnsPerSkipped = this.getTurnsPerSkippedTurn();
        o.append("<tr><td>Skipped turns per round</td><td>" + skippedPerRound.getMin() + "</td><td>" + World.twodp.format(skippedPerRound.getAverage()) + "</td><td>" + skippedPerRound.getMax() + "</td></tr>\n");
        o.append("<tr><td>Turns per skipped turn</td><td>" + turnsPerSkipped.getMin() + "</td><td>" + World.twodp.format(turnsPerSkipped.getAverage()) + "</td><td>" + turnsPerSkipped.getMax() + "</td></tr></table>\n");
        return o.toString();
    }

    void reportSurvivorDistribution(Writer w) throws IOException {
        w.write("<a name=survivordist><h3>Survival statistics</h3>\n");
        w.write("Average survivor position " + World.twodp.format(this.survivorPosition.getAverage()) + ".<br>\n");
        w.write("<table><caption>Survival position distribution</caption>\n");
        w.write("<tr><th>Position</th><th># of times</th></tr>\n");
        int i = 1;
        while (i <= this.totalEnemies + 1) {
            w.write("<tr><td>" + i + "</td><td>" + this.survivorDistribution[i] + "</td></tr>\n");
            ++i;
        }
        w.write("</table>\n");
    }

    public void createReport() {
        String ourName = World.getAdvancedRobot().getName();
        String date = DateFormat.getDateTimeInstance().format(new Date());
        int roundNum = World.getAdvancedRobot().getRoundNum();
        int numRounds = World.getAdvancedRobot().getNumRounds();
        try {
            RobocodeFileWriter file = new RobocodeFileWriter(World.getDataFile("report.html"));
            file.write("<html><head></head><body>\n");
            file.write("<h1>Mooserwirt performance report</h1>");
            file.write("<p><i>A robot by <a href=\"http://www.glyndavies.org\">Glyn Davies</a></i><br>\n");
            file.write("Report created by " + ourName + " at " + date + "<br>\n");
            file.write("Round " + (roundNum + 1) + " of " + numRounds + ".<br>\n");
            file.write("<a href=#survivordist>Survival Statistics</a> | ");
            file.write("<a href=#proctimes>Turn processing times</a> | ");
            file.write("<a href=#shotaccuracy>Shot accuracy</a> | ");
            file.write("<a href=#movepredict>Movement Prediction</a>\n");
            this.reportSurvivorDistribution((Writer)file);
            file.write(this.reportProcessingTimes());
            file.write(this.reportShotAccuracyHtml());
            file.write(this.reportPredictionAccuracyHtml());
            file.write("</body></html>\n");
            file.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    static /* synthetic */ int[] access$102(Stats x0, int[] x1) {
        x0.survivorDistribution = x1;
        return x1;
    }

    class RobotEventListener
    extends AdvancedRobotAdapter {
        RobotEventListener() {
        }

        public void onRoundStart(AdvancedRobot ar) {
            if (ar.getRoundNum() == 0) {
                Stats.this.totalEnemies = ar.getOthers();
                Stats.access$102(Stats.this, new int[Stats.this.totalEnemies + 2]);
            }
        }

        public void onHitByBullet(HitByBulletEvent bhe) {
            EnemyStats stats = Stats.this.getEnemyStats(bhe.getName());
            ++stats.hitUs;
            stats.damageOnUs += World.calcBulletDamage(bhe.getPower());
            if (World.getAdvancedRobot().getEnergy() <= 0.0) {
                ++stats.killedUs;
            }
        }

        public void onBulletHit(BulletHitEvent bhe) {
            EnemyStats stats = Stats.this.getEnemyStats(bhe.getName());
            ++stats.hitThem;
            stats.damageOnThem += World.calcBulletDamage(bhe.getBullet().getPower());
            if (bhe.getEnergy() == 0.0) {
                ++stats.killedThem;
            }
            if (Stats.this.bulletAimedAt.containsKey(bhe.getBullet())) {
                String origTarget = (String)Stats.this.bulletAimedAt.get(bhe.getBullet());
                String robotHit = bhe.getName();
                EnemyStats origTargetStats = Stats.this.getEnemyStats(origTarget);
                if (origTarget.equals(robotHit)) {
                    origTargetStats.getOurAccuracy().nextValue(1.0);
                } else {
                    origTargetStats.getOurAccuracy().nextValue(0.0);
                }
                Stats.this.bulletAimedAt.remove(bhe.getBullet());
            }
        }

        public void onBulletMissed(BulletMissedEvent bme) {
            if (Stats.this.bulletAimedAt.containsKey(bme.getBullet())) {
                String origTarget = (String)Stats.this.bulletAimedAt.get(bme.getBullet());
                EnemyStats stats = Stats.this.getEnemyStats(origTarget);
                stats.getOurAccuracy().nextValue(0.0);
                Stats.this.bulletAimedAt.remove(bme.getBullet());
            }
        }

        public void onWin(WinEvent win) {
            Stats.this.survivorPosition.nextValue(1.0);
            int[] nArray = Stats.this.survivorDistribution;
            nArray[1] = nArray[1] + 1;
        }

        public void onDeath(DeathEvent death) {
            int others = World.getAdvancedRobot().getOthers();
            Stats.this.survivorPosition.nextValue(others + 1);
            int[] nArray = Stats.this.survivorDistribution;
            int n = others + 1;
            nArray[n] = nArray[n] + 1;
        }
    }
}

