/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation;

import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.matrix.SparseMatrix;
import org.la4j.operation.MatrixMatrixOperation;

public abstract class SymmetricMatrixMatrixOperation<R>
extends MatrixMatrixOperation<R> {
    @Override
    public R apply(DenseMatrix a, RowMajorSparseMatrix b) {
        return this.applySymmetric(a, (SparseMatrix)b);
    }

    @Override
    public R apply(DenseMatrix a, ColumnMajorSparseMatrix b) {
        return this.applySymmetric(a, (SparseMatrix)b);
    }

    @Override
    public R apply(RowMajorSparseMatrix a, DenseMatrix b) {
        return this.applySymmetric(b, (SparseMatrix)a);
    }

    @Override
    public R apply(RowMajorSparseMatrix a, ColumnMajorSparseMatrix b) {
        return this.applySymmetric(a, b);
    }

    @Override
    public R apply(ColumnMajorSparseMatrix a, DenseMatrix b) {
        return this.applySymmetric(b, (SparseMatrix)a);
    }

    @Override
    public R apply(RowMajorSparseMatrix a, RowMajorSparseMatrix b) {
        return this.applySymmetric((SparseMatrix)a, (SparseMatrix)b);
    }

    @Override
    public R apply(ColumnMajorSparseMatrix a, ColumnMajorSparseMatrix b) {
        return this.applySymmetric(a, (SparseMatrix)b);
    }

    @Override
    public R apply(ColumnMajorSparseMatrix a, RowMajorSparseMatrix b) {
        return this.applySymmetric(b, a);
    }

    public abstract R applySymmetric(DenseMatrix var1, SparseMatrix var2);

    public abstract R applySymmetric(SparseMatrix var1, SparseMatrix var2);

    public abstract R applySymmetric(RowMajorSparseMatrix var1, ColumnMajorSparseMatrix var2);
}

