/*
 * Decompiled with CFR 0.152.
 */
package mmb;

import mmb.AssaultBehavior;
import mmb.AttackBehavior;
import mmb.Behavior;
import mmb.BrownianMotion;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;

public class BehaviorManager {
    private Behavior currentBehavior = null;
    AdvancedRobot robot = null;
    BrownianMotion brownianMotion = null;
    AssaultBehavior assaultBehavior = null;
    AttackBehavior attackBehavior = null;

    public BehaviorManager(AdvancedRobot robot) {
        this.robot = robot;
        this.assaultBehavior = new AssaultBehavior(robot);
        this.attackBehavior = new AttackBehavior(robot);
        this.brownianMotion = new BrownianMotion(robot);
        this.currentBehavior = this.brownianMotion;
    }

    public void setAction() {
        this.currentBehavior.setAction();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double enemyEnergy = e.getEnergy();
        double enemyDistance = e.getDistance();
        double robotEnergy = this.robot.getEnergy();
        this.currentBehavior = enemyDistance < 400.0 ? this.attackBehavior : this.brownianMotion;
        this.currentBehavior.onScannedRobot(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
        this.currentBehavior.onHitWall(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.currentBehavior.onHitRobot(e);
    }

    public Behavior getBehavior() {
        return this.currentBehavior;
    }
}

